package lib.asal.parsing;

import java.util.*;

public class ASALRuleOpportunities {
	private Map<ASALToken, Set<String>> opportunities;
	
	public ASALRuleOpportunities() {
		opportunities = new HashMap<ASALToken, Set<String>>();
	}
	
	public ASALRuleOpportunities(ASALRuleOpportunities source) {
		opportunities = new HashMap<ASALToken, Set<String>>();
		
		for (Map.Entry<ASALToken, Set<String>> entry : source.opportunities.entrySet()) {
			opportunities.put(entry.getKey(), new HashSet<String>(entry.getValue()));
		}
	}
	
	public boolean isEmpty() {
		return opportunities.isEmpty();
	}
	
	private Set<String> getSet(ASALToken token) {
		Set<String> v = opportunities.get(token);
		
		if (v == null) {
			v = new HashSet<String>();
			opportunities.put(token, v);
		}
		
		return v;
	}
	
	public void add(ASALToken token, String s) {
		getSet(token).add(s);
	}
	
	public void add(ASALToken token, Set<String> s) {
		getSet(token).addAll(s);
	}
	
	public void addAll(ASALRuleOpportunities other) {
		for (Map.Entry<ASALToken, Set<String>> entry : other.opportunities.entrySet()) {
			add(entry.getKey(), entry.getValue());
		}
	}
	
	public List<String> getSuggestions() {
		List<String> result = new ArrayList<String>();
		
		for (Map.Entry<ASALToken, Set<String>> entry : opportunities.entrySet()) {
			for (String s : entry.getValue()) {
				result.add("Perhaps you meant " + s + " instead of " + entry.getKey() + "?");
			}
		}
		
		return result;
	}
	
	public String getSuggestions(String prefix) {
		List<String> suggestions = getSuggestions();
		
		if (suggestions.size() > 0) {
			String result = suggestions.get(0);
			
			for (int index = 1; index < suggestions.size(); index++) {
				result += "\n" + prefix + suggestions.get(index);
			}
			
			return result;
		}
		
		return "";
	}
}
