package lib.asal.parsing;

@SuppressWarnings("serial")
public class ASALException extends Exception {
	public ASALException(String msg) {
		super(msg);
	}
	
	public ASALException(String msg, Throwable t) {
		super(msg, t);
	}
	
//	public ASALException(String msg, ASALSyntaxTree tree) {
//		this(msg, tree.getFirstToken());
//	}
	
	public ASALException(String msg, ASALSyntaxTreeAPI treeAPI) {
		this(msg, treeAPI.getTree().getFirstToken());
	}
	
	public ASALException(String prefix, ASALSyntaxTreeAPI treeAPI, String suffix) {
		this(prefix, treeAPI.getTree().getFirstToken(), suffix);
	}
	
	public ASALException(String msg, ASALToken token) {
		this(msg, token, "!");
	}
	
	public ASALException(String prefix, ASALToken token, String suffix) {
		this(prefix + (token != null ? " (" + token.toString() + ")" : "") + suffix);
	}
	
	public ASALException(String msg, String[] code, Throwable t) {
		this(msg, code, "", t);
	}
	
	public ASALException(String prefix, String[] code, String suffix) {
		this(prefix, code, suffix, null);
	}
	
	public ASALException(String prefix, String[] code, String suffix, Throwable t) {
		super(prefix + "\n" + codeToString(code) + suffix, t);
	}
	
	private static String codeToString(String[] code) {
		String result = "";
		
		for (int index = 0; index < code.length; index++) {
			result += "\t" + (index + 1) + ": " + code[index] + "\n";
		}
		
		return result;
	}
}
