package lib.asal;

import lib.behave.Variable;
import lib.utils.LOD;

public class ASALVariableImpl<T> implements ASALVariable<T> {
	private String name;
	private Variable declaration;
	private ASALVarOrigin origin;
	
	public ASALVariableImpl(String name, Variable declaration, ASALVarOrigin origin) {
		this.name = name;
		this.declaration = declaration;
		this.origin = origin;
	}
	
	@Override
	public String getName() {
		return name;
	}
	
	public Variable getDecl() {
		return declaration;
	}
	
	@Override
	public ASALDataType getType() {
		return declaration.getType();
	}
	
	@Override
	public ASALVarOrigin getOrigin() {
		return origin;
	}
	
	@Override
	public boolean isContinuous() {
		return false;
	}
	
	@Override
	public String textify(LOD lod) {
		String result = lod.abbreviate(name);
		
		if (lod.includesType) {
			result = result + ": " + getType().name;
		}
		
		return result;
	}
}
