package lib.asal;

import lib.asal.parsing.api.*;

public abstract class ASALHandler<T> {
	public T handle(ASALAssignStatement node, T var, T expr) {
		return null;
	}
	
	public T handle(ASALBinaryExpr node, T lhs, T rhs) {
		return null;
	}
	
	public T handle(ASALEmptyStatement node) {
		return null;
	}
	
	public T handle(ASALFunctionCall node, T fct, Object... params) {
		return null;
	}
	
	public T handle(ASALFunctionCallStatement node, T fct, Object... params) {
		return null;
	}
	
	public T handle(ASALIfStatement node, T cond, T thenBranch, T elseBranch) {
		return null;
	}
	
	public T handle(ASALWhileStatement node, T cond, T body) {
		return null;
	}
	
	public T handle(ASALReturnStatement node, T expr) {
		return null;
	}
	
	public T handle(ASALSeqStatement node, T first, T second) {
		return null;
	}
	
	public T handle(ASALVarRef node, T var) {
		return null;
	}
	
	public T handle(ASALUnaryExpr node, T expr) {
		return null;
	}
	
	public T handle(ASALFunction leaf, T stat) {
		return null;
	}
	
	public T handle(ASALVariable<?> leaf) {
		return null;
	}
	
	public T handle(ASALLiteral leaf) {
		return null;
	}
	
	public T handle(ASALTrigger node, T expr) {
		return null;
	}
	
	public T handle(ASALTimeout node, T duration) {
		return null;
	}
	
	public T handle(ASALCall node, T fct) {
		return null;
	}
}
