package lib.asal;

import java.util.*;

import lib.asal.parsing.ASALException;
import lib.asal.parsing.api.ASALStatement;
import lib.behave.Function;

public interface ASALFunction {
	public String getName();
	public List<ASALVariable<?>> getParams();
	public ASALDataType getReturnType();
	public Set<ASALFunction> getVisitedFunctions(ASALContext context);
	public boolean isPure(ASALContext context);
	public void parse(ASALContextDecls context) throws ASALException;
	public Function getDeclaration();
	public ASALStatement getBody();
	public ASALContext createContext(ASALContext nestingContext);
}
