package lib.asal;

import lib.blocks.common.Pulse;

public enum ASALDataType {
	VOID("void", null, null, false, false),
	PULSE("pulse", Pulse.class, Pulse.FALSE, true, false),
	BOOLEAN("boolean", Boolean.class, Boolean.FALSE, true, false),
	NUMBER("number", Integer.class, 0, false, true),
	STRING("string", String.class, "", false, false),
	
	;
	
	public final String name;
	public final Class<?> javaClass;
	public final Object defaultValue;
	public final boolean isBooleanType;
	public final boolean isOrderedType;
	
	private <T> ASALDataType(String name, Class<T> javaClass, T defaultValue, boolean isBooleanType, boolean isOrderedType) {
		this.name = name;
		this.javaClass = javaClass;
		this.defaultValue = defaultValue;
		this.isBooleanType = isBooleanType;
		this.isOrderedType = isOrderedType;
	}
	
	@Override
	public String toString() {
		return name;
	}
	
	public static ASALDataType get(Class<?> javaClass) {
		for (ASALDataType v : values()) {
			if (v.javaClass != null && v.javaClass.isAssignableFrom(javaClass)) {
				return v;
			}
		}
		
		throw new Error("Could not find value that corresponds with " + javaClass.getCanonicalName() + "!");
	}
	
	public static ASALDataType get(String name) {
		for (ASALDataType v : values()) {
			if (v.name.equals(name)) {
				return v;
			}
		}
		
		throw new Error("Could not find value that corresponds with " + name + "!");
	}
	
	public boolean isAssignableTo(ASALDataType other) {
		switch (this) {
			case BOOLEAN:
			case PULSE:
				return other == BOOLEAN || other == PULSE;
			case NUMBER:
				return other == NUMBER;
			case STRING:
				return other == STRING;
			case VOID:
				return false;
			default:
				throw new Error("Assignment of " + other.name + " to " + name + " is undefined!");
		}
	}
	
	public boolean isEquatable(ASALDataType other) {
		return isAssignableTo(other) || other.isAssignableTo(this);
	}
}
