package lib.asal;

import java.util.*;

public abstract class ASALContext {
	public final Map<String, ASALVariable<?>> fctParams;
	public final Map<String, ASALVariable<?>> inPortVars;
	public final Map<String, ASALVariable<?>> outPortVars;
	public final Map<String, ASALVariable<?>> stateMachineVars;
	public final Map<String, ASALFunction> functions;
	
	public ASALContext() {
		fctParams = new HashMap<String, ASALVariable<?>>();
		inPortVars = new HashMap<String, ASALVariable<?>>();
		outPortVars = new HashMap<String, ASALVariable<?>>();
		stateMachineVars = new HashMap<String, ASALVariable<?>>();
		functions = new HashMap<String, ASALFunction>();
	}
	
	public ASALContext(ASALContext source) {
		fctParams = new HashMap<String, ASALVariable<?>>(source.fctParams);
		inPortVars = new HashMap<String, ASALVariable<?>>(source.inPortVars);
		outPortVars = new HashMap<String, ASALVariable<?>>(source.outPortVars);
		stateMachineVars = new HashMap<String, ASALVariable<?>>(source.stateMachineVars);
		functions = new HashMap<String, ASALFunction>(source.functions);
	}
	
	public final ASALVariable<?> getWritableVariable(String name) {
		ASALVariable<?> result = fctParams.get(name);
		
		if (result != null) {
			return result;
		}
		
		result = outPortVars.get(name);
		
		if (result != null) {
			return result;
		}
		
		return stateMachineVars.get(name);
	}
	
	public final ASALVariable<?> getVariable(String name) {
		ASALVariable<?> v = getWritableVariable(name);
		
		if (v != null) {
			return v;
		}
		
		return inPortVars.get(name);
	}
	
	public final ASALFunction getFunction(String name) {
		return functions.get(name);
	}
}
