package example.testing;

import lib.asal.ASALDataType;
import lib.behave.*;

public class Worker_STM extends StateMachine {
	public final static Variable counter = new Variable(ASALDataType.NUMBER);
	
	public final static Function getResult = new Function(ASALDataType.BOOLEAN,
		"if counter%2 = 0 then",
		"	counter := counter + 1;",
		"	return TRUE;",
		"else",
		"	counter := counter + 1;",
		"	return TRUE;",
		"end if"
	);
	
	public static class Initial0 extends InitialVertex {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(STANDBY.class,
					"/counter := 0; start := FALSE;"
				)
			};
		}
	}
	
	public static class STANDBY extends State {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(COMPUTING.class,
					"when(start)/"
				)
			};
		
		}
	}
		
	public static class COMPUTING extends State {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(STANDBY.class,
					"/result := getResult(); notify := TRUE;"
				)
			};
		}
	}
}

