package example.point;

import lib.asal.ASALDataType;
import lib.behave.*;

/**
 * Generic interface and subsystem requirements (v3.0)
 * Page 32
 */
public class SCI_P_STD_1 extends StateMachine {
	public final static Variable Mem_Move_Point = new Variable(ASALDataType.STRING);
	public final static Variable Mem_Point_Position = new Variable(ASALDataType.STRING);
	
	public final static Function cOp1_Init = new Function(ASALDataType.VOID,
		"T1_Cd_Move_Point := FALSE;",
		"DT1_Move_Point_Target := \"\";",
		"T20_Point_Position := FALSE;",
		"DT20_Point_Position := \"\";",
		"T30_Timeout := FALSE;",
		"Mem_Move_Point := \"\";",
		"Mem_Point_Position := \"\";"
	);
	
	public static class Initial0 extends InitialVertex {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(RECEIVING_STATUS_REPORT.class,
					"cOp1_Init();"
				)
			};
		}
	}
	
	public static class RECEIVING_STATUS_REPORT extends CompositeState {
		public static class Initial1 extends InitialVertex {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(REPORT_STATUS.class, "/")
				};
			}
		}
		
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(RECEIVING_STATUS_REPORT.class,
					"when(D21_S_SCI_EfeS_Gen_SR_State = \"CLOSED\") /"
				)
			};
		}
		
		public static class REPORT_STATUS extends State {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(STATUS_REPORTED.class,
						"when(T2_Msg_Point_Position) /",
						"DT20_Point_Position := DT2_Point_Position;",
						"T20_Point_Position := TRUE;",
						"Mem_Point_Position := DT2_Point_Position;"
					)
				};
			}
		}
		
		public static class STATUS_REPORTED extends State {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(PDI_CONNECTION_ESTABLISHED.class,
						"when(D21_S_SCI_EfeS_Gen_SR_State = \"ESTABLISHED\")",
						"[Mem_Point_Position = DT2_Point_Position] /"
					),
					new Outgoing(PDI_CONNECTION_ESTABLISHED.class,
						"when(D21_S_SCI_EfeS_Gen_SR_State = \"ESTABLISHED\")",
						"[Mem_Point_Position <> DT2_Point_Position] /",
						"Mem_Point_Position := DT2_Point_Position;",
						"DT20_Point_Position := DT2_Point_Position;",
						"T20_Point_Position := TRUE;"
					)
				};
			}
		}
	}
	
	public static class PDI_CONNECTION_ESTABLISHED extends State {
		@Override
		public LocalTransition[] onDo() {
			return new LocalTransition[] {
				new LocalTransition(
					"when(T10_Move_Point) /",
					"DT1_Move_Point_Target := DT10_Move_Point;",
					"T1_Cd_Move_Point := TRUE;"
				),
				new LocalTransition(
					"when(T2_Msg_Point_Position) /",
					"DT20_Point_Position := DT2_Point_Position;",
					"T20_Point_Position := TRUE;"
				),
				new LocalTransition(
					"when(T3_Msg_Timeout) / ",
					"T30_Timeout := TRUE;"
				)
			};
		}
		
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(RECEIVING_STATUS_REPORT.class,
					"when(D21_S_SCI_EfeS_Gen_SR_State <> \"ESTABLISHED\") /"
				)
			};
		}
	}
}
