package example.point;

import lib.asal.ASALDataType;
import lib.behave.*;

/**
 * Generic interface and subsystem requirements (v3.0)
 * Page 38
 */
public class F_P3_SR_STD_1 extends StateMachine {
	public final static Variable Mem_last_Target_Requested = new Variable(ASALDataType.STRING);
	public final static Variable Mem_Current_Point_Position = new Variable(ASALDataType.STRING);
	
	public final static Function cOp1_Init = new Function(ASALDataType.VOID,
		"T4_Information_No_End_Position := FALSE;",
		"T5_Info_End_Position_Arrived := FALSE;",
		"D5_Drive_State := \"STOPPED\";",
		"D6_Detection_State := \"\";",
		"T6_Information_Trailed_Point := FALSE;",
		"T7_Information_Out_Of_Sequence := FALSE;",
		"D10_Move_Left := FALSE;",
		"D11_Move_Right := FALSE;",
		"T20_Point_Position := FALSE;",
		"DT20_Point_Position := \"UNKNOWN\";",
		"D25_Redrive := FALSE;",
		"T30_Report_Timeout := FALSE;",
		"Mem_last_Target_Requested := \"\";",
		"Mem_Current_Point_Position := \"\";"
	);
	
	public final static Function cOp2_All_Left = new Function(ASALDataType.BOOLEAN,
		"if cOp8_Supports_Multiple_PMs() then",
		"  return (",
		"    D21_PM1_Position = \"LEFT\" and",
		"    (D22_PM2_Position = \"LEFT\" or D13_PM2_Activation = \"INACTIVE\")",
		"  );",
		"else",
		"  return D21_PM1_Position = \"LEFT\";",
		"end if"
	);
	
	public final static Function cOp3_No_End_Position = new Function(ASALDataType.BOOLEAN,
		"return not cOp6_Error() and not cOp5_Trailed() and not cOp2_All_Left() and not cOp4_All_Right();"
	);
	
	public final static Function cOp4_All_Right = new Function(ASALDataType.BOOLEAN,
		"if cOp8_Supports_Multiple_PMs() then",
		"  return (",
		"    D21_PM1_Position = \"RIGHT\" and",
		"    (D22_PM2_Position = \"RIGHT\" or D13_PM2_Activation = \"INACTIVE\")",
		"  );",
		"else",
		"  return D21_PM1_Position = \"RIGHT\";",
		"end if"
	);
	
	public final static Function cOp5_Trailed = new Function(ASALDataType.BOOLEAN,
		"if not cOp6_Error() then",
		"  if cOp8_Supports_Multiple_PMs() then",
		"    return D21_PM1_Position = \"TRAILED\" or D22_PM2_Position = \"TRAILED\";",
		"  else",
		"    return D21_PM1_Position = \"TRAILED\";",
		"  end if",
		"else",
		"  return FALSE;",
		"end if"
	);
	
	public final static Function cOp6_Error = new Function(ASALDataType.BOOLEAN,
		"if cOp8_Supports_Multiple_PMs() then",
		"  return D21_PM1_Position = \"ERROR\" or D22_PM2_Position = \"ERROR\";",
		"else",
		"  return D21_PM1_Position = \"ERROR\";",
		"end if"
	);
	
	public final static Function cOp7_Is_Trailable = new Function(ASALDataType.BOOLEAN,
		"return D32_Con_007600 or D33_Con_007900 or D34_Con_008000 or D35_Con_008200;"
	);
	
	public final static Function cOp8_Supports_Multiple_PMs = new Function(ASALDataType.BOOLEAN,
		"return D30_Con_007000 or D32_Con_007600 or D33_Con_007900 or D34_Con_008000 or D35_Con_008200 or D37_Con_008400;"
	);
	
	public final static Function cOp9_Redrive_Enabled = new Function(ASALDataType.BOOLEAN,
		"return D30_Con_007000;"
	);
	
	public final static Function cOp10_Redrive_Right = new Function(ASALDataType.BOOLEAN,
		"return cOp3_No_End_Position() and Mem_last_Target_Requested = \"RIGHT\" and Mem_Current_Point_Position = \"RIGHT\";"
	);
	
	public final static Function cOp11_Redrive_Left = new Function(ASALDataType.BOOLEAN,
		"return cOp3_No_End_Position() and Mem_last_Target_Requested = \"LEFT\" and Mem_Current_Point_Position = \"LEFT\";"
	);
	
	public final static Function cOp12_Timeout = new Function(ASALDataType.VOID,
		"D5_Drive_State := \"STOPPED\";",
		"if D32_Con_007600 or D33_Con_007900 or D34_Con_008000 or D35_Con_008200 or D37_Con_008400 then",
		"  T30_Report_Timeout := TRUE;",
		"end if"
	);
	
	public final static Function cOp13_Not_Initialised = new Function(ASALDataType.BOOLEAN,
		"return D20_F_EST_EfeS_Gen_SR_State = \"NO_OPERATING_VOLTAGE\"",
		"  or D20_F_EST_EfeS_Gen_SR_State = \"BOOTING\"",
		"  or D20_F_EST_EfeS_Gen_SR_State = \"FALLBACK_MODE\";"
	);
	
	public static class Initial0 extends InitialVertex {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(OPERATING.class,
					"cOp1_Init();"
				)
			};
		}
	}
	
	public static class OPERATING extends CompositeState {
		public static class Initial1 extends InitialVertex {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(WAITING_FOR_INITIALISING.class,
						"/"
					)
				};
			}
		}
		
		public static class WAITING_FOR_INITIALISING extends State {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(Junction0.class,
						"when(D20_F_EST_EfeS_Gen_SR_State = \"INITIALISING\") /"
					)
				};
			}
		}
		
		public static class Junction0 extends JunctionVertex {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(NO_END_POSITION.class,
						"[cOp3_No_End_Position()] /"
					),
					new Outgoing(ALL_LEFT.class,
						"[cOp2_All_Left()] /"
					),
					new Outgoing(ALL_RIGHT.class,
						"[cOp4_All_Right()] /"
					),
					new Outgoing(TRAILED.class,
						"[cOp5_Trailed() and cOp7_Is_Trailable()] /"
					)
				};
			}
		}
		
		public static class NO_END_POSITION extends State {
			@Override
			public LocalTransition onEntry() {
				return new LocalTransition(
					"Entry /",
					"DT20_Point_Position := \"NO_END_POSITION\";",
					"T20_Point_Position := TRUE;",
					"Mem_Current_Point_Position := \"NO_END_POSITION\";",
					"T4_Information_No_End_Position := TRUE;",
					"D6_Detection_State := \"NO_END_POSITION\";"
				);
			}
			
			@Override
			public LocalTransition onExit() {
				return new LocalTransition(
					"Exit /",
					"T4_Information_No_End_Position := FALSE;"
				);
			}
			
			@Override
			public LocalTransition[] onDo() {
				return new LocalTransition[] {
					new LocalTransition(
						"when(T40_Report_Status) /",
						"DT20_Point_Position := \"NO_END_POSITION\";",
						"T20_Point_Position := TRUE;"
					)
				};
			}
			
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(ALL_LEFT.class,
						"when(cOp2_All_Left()) /"
					),
					new Outgoing(ALL_RIGHT.class,
						"when(cOp4_All_Right()) /"
					),
					new Outgoing(WAITING_FOR_INITIALISING.class,
						"when(cOp13_Not_Initialised()) /"
					)
				};
			}
		}
		
		public static class ALL_LEFT extends State {
			@Override
			public LocalTransition onEntry() {
				return new LocalTransition(
					"Entry /",
					"DT20_Point_Position := \"LEFT\";",
					"T20_Point_Position := TRUE;",
					"Mem_Current_Point_Position := \"LEFT\";",
					"T5_Info_End_Position_Arrived := TRUE;",
					"D6_Detection_State := \"END_POSITION\";"
				);
			}
			
			@Override
			public LocalTransition onExit() {
				return new LocalTransition(
					"Exit /",
					"T5_Info_End_Position_Arrived := FALSE;"
				);
			}
			
			@Override
			public LocalTransition[] onDo() {
				return new LocalTransition[] {
					new LocalTransition(
						"when(T40_Report_Status) /",
						"DT20_Point_Position := \"LEFT\";",
						"T20_Point_Position := TRUE;"
					)
				};
			}
			
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(NO_END_POSITION.class,
						"when(cOp3_No_End_Position()) /"
					),
					new Outgoing(ALL_RIGHT.class,
						"when(cOp4_All_Right()) /"
					),
					new Outgoing(WAITING_FOR_INITIALISING.class,
						"when(cOp13_Not_Initialised()) /"
					),
					new Outgoing(TRAILED.class,
						"when(cOp5_Trailed()) [cOp7_Is_Trailable()] /"
					)
				};
			}
		}
		
		public static class ALL_RIGHT extends State {
			@Override
			public LocalTransition onEntry() {
				return new LocalTransition(
					"Entry /",
					"DT20_Point_Position := \"RIGHT\";",
					"T20_Point_Position := TRUE;",
					"Mem_Current_Point_Position := \"RIGHT\";",
					"T5_Info_End_Position_Arrived := TRUE;",
					"D6_Detection_State := \"END_POSITION\";"
				);
			}
			
			@Override
			public LocalTransition onExit() {
				return new LocalTransition(
					"Exit /",
					"T5_Info_End_Position_Arrived := FALSE;"
				);
			}
			
			@Override
			public LocalTransition[] onDo() {
				return new LocalTransition[] {
					new LocalTransition(
						"when(T40_Report_Status) /",
						"DT20_Point_Position := \"RIGHT\";",
						"T20_Point_Position := TRUE;"
					)
				};
			}
			
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(NO_END_POSITION.class,
						"when(cOp3_No_End_Position()) /"
					),
					new Outgoing(ALL_LEFT.class,
						"when(cOp2_All_Left()) /"
					),
					new Outgoing(WAITING_FOR_INITIALISING.class,
						"when(cOp13_Not_Initialised()) /"
					),
					new Outgoing(TRAILED.class,
						"when(cOp5_Trailed()) [cOp7_Is_Trailable()] /"
					)
				};
			}
		}
		
		public static class TRAILED extends State {
			@Override
			public LocalTransition onEntry() {
				return new LocalTransition(
					"Entry /",
					"DT20_Point_Position := \"TRAILED\";",
					"T20_Point_Position := TRUE;",
					"Mem_Current_Point_Position := \"TRAILED\";",
					"T6_Information_Trailed_Point := TRUE;",
					"D6_Detection_State := \"TRAILED\";"
				);
			}
			
			@Override
			public LocalTransition onExit() {
				return new LocalTransition(
					"Exit /",
					"T6_Information_Trailed_Point := FALSE;"
				);
			}
			
			@Override
			public LocalTransition[] onDo() {
				return new LocalTransition[] {
					new LocalTransition(
						"when(T40_Report_Status) /",
						"DT20_Point_Position := \"TRAILED\";",
						"T20_Point_Position := TRUE;"
					)
				};
			}
			
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(NO_END_POSITION.class,
						"when(cOp3_No_End_Position()) /"
					),
					new Outgoing(ALL_LEFT.class,
						"when(cOp2_All_Left()) /"
					),
					new Outgoing(ALL_RIGHT.class,
						"when(cOp4_All_Right()) /"
					),
					new Outgoing(WAITING_FOR_INITIALISING.class,
						"when(cOp13_Not_Initialised()) /"
					)
				};
			}
		}
		
		public static class Initial2 extends InitialVertex {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(STOPPED.class,
						"/"
					)
				};
			}
		}
		
		public static class STOPPED extends State {
			@Override
			public LocalTransition onEntry() {
				return new LocalTransition(
					"Entry / D25_Redrive := FALSE;",
					"D5_Drive_State := \"STOPPED\";"
				);
			}
			
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(Junction1.class,
						"when(T1_Move) [DT1_Move_Target = \"LEFT\"] /"
					),
					new Outgoing(Junction2.class,
						"when(T1_Move) [DT1_Move_Target = \"RIGHT\"] /"
					),
					new Outgoing(MOVING_LEFT.class,
						"when(cOp11_Redrive_Left()) [cOp9_Redrive_Enabled()] /",
						"D25_Redrive := TRUE;"
					),
					new Outgoing(MOVING_RIGHT.class,
						"when(cOp10_Redrive_Right()) [cOp9_Redrive_Enabled()] /",
						"D25_Redrive := TRUE;"
					)
				};
			}
		}
		
		public static class Junction1 extends JunctionVertex {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(STOPPED.class,
						"[DT1_Move_Target = Mem_Current_Point_Position] /",
						"T20_Point_Position := TRUE;"
					),
					new Outgoing(MOVING_LEFT.class,
						"[DT1_Move_Target <> Mem_Current_Point_Position] /"
					)
				};
			}
		}
		
		public static class Junction2 extends JunctionVertex {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(STOPPED.class,
						"[DT1_Move_Target = Mem_Current_Point_Position] /",
						"T20_Point_Position := TRUE;"
					),
					new Outgoing(MOVING_RIGHT.class,
						"[DT1_Move_Target <> Mem_Current_Point_Position] /"
					)
				};
			}
		}
		
		public static class MOVING_LEFT extends State {
			@Override
			public LocalTransition onEntry() {
				return new LocalTransition(
					"Entry / D10_Move_Left := TRUE;",
					"D5_Drive_State := \"MOVING\";",
					"Mem_last_Target_Requested := \"LEFT\";"
				);
			}
			
			@Override
			public LocalTransition onExit() {
				return new LocalTransition(
					"Exit / D10_Move_Left := FALSE;"
				);
			}
			
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(MOVING_RIGHT.class,
						"when(T1_Move) [DT1_Move_Target = \"RIGHT\"] /"
					),
					new Outgoing(STOPPED.class,
						"after(D4_Con_tmax_Point_Operation) / cOp12_Timeout();"
					),
					new Outgoing(STOPPED.class,
						"when(cOp2_All_Left()) /"
					),
					new Outgoing(STOPPED.class,
						"[cOp13_Not_Initialised()] /"
					)
				};
			}
		}
		
		public static class MOVING_RIGHT extends State {
			@Override
			public LocalTransition onEntry() {
				return new LocalTransition(
					"Entry / D11_Move_Right := TRUE;",
					"D5_Drive_State := \"MOVING\";",
					"Mem_last_Target_Requested := \"RIGHT\";"
				);
			}
			
			@Override
			public LocalTransition onExit() {
				return new LocalTransition(
					"Exit / D11_Move_Right := FALSE;"
				);
			}
			
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(MOVING_LEFT.class,
						"when(T1_Move) [DT1_Move_Target = \"LEFT\"] /"
					),
					new Outgoing(STOPPED.class,
						"after(D4_Con_tmax_Point_Operation) / cOp12_Timeout();"
					),
					new Outgoing(STOPPED.class,
						"when(cOp4_All_Right()) /"
					),
					new Outgoing(STOPPED.class,
						"[cOp13_Not_Initialised()] /"
					)
				};
			}
		}
	}
}

