package example.pdi;

import lib.behave.*;

public class SCI_SCP_Sec_STD_1 extends StateMachine {
	public static class Initial0 extends InitialVertex {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(CLOSED.class, "/")
			};
		}
	}
	
	public static class CLOSED extends State {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(START.class, "when(T5_Conn_Req) / T6_Conn_Resp := TRUE;")
			};
		}
	}
	
	public static class START extends State {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(Junction0.class, "when(T8_Disc_Requ) /"),
				new Outgoing(Junction0.class, "after(D100_Mem_Tmax) /"),
				new Outgoing(UP.class, "when(T7_HB) / T1_SCP_Connection_Established := TRUE;")
			};
		}
	}
	
	public static class UP extends State {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(Junction0.class, "when(T8_Disc_Requ) / T2_SCP_Connection_Terminated := TRUE;"),
				new Outgoing(Junction1.class, "when(T3_HB_inacceptable_delayed) /"),
				new Outgoing(Junction1.class, "when(T4_Terminate_SCP_Connection) / T9_Disc_Requ := TRUE;")
			};
		}
	}
	
	public static class Junction0 extends JunctionVertex {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(CLOSED.class, "/")
			};
		}
	}
	
	public static class Junction1 extends JunctionVertex {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(CLOSED.class, "/ T2_SCP_Connection_Terminated := TRUE;")
			};
		}
	}
}

