package example.pdi;

import lib.behave.*;

public class SCI_SCP_Prim_STD_1 extends StateMachine {
	public static class Initial0 extends InitialVertex {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(CLOSED.class, "/")
			};
		}
	}
	
	public static class CLOSED extends State {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(START.class, "when(T1_Establish_SCP_Connection) / T6_Conn_Req := TRUE;")
			};
		}
	}
	
	public static class START extends State {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(Junction0.class, "after(D100_Mem_Tmax) /"),
				new Outgoing(Junction1.class, "when(T7_Conn_Resp) /")
			};
		}
	}
	
	public static class UP extends State {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(Junction0.class, "when(T2_Terminate_SCP_Connection) / T5_SCP_Connection_Terminated := TRUE;"),
				new Outgoing(Junction2.class, "when(T3_HB_inacceptable_delayed) /"),
				new Outgoing(Junction2.class, "when(T11_Disc_Req) /")
			};
		}
	}
	
	public static class Junction0 extends JunctionVertex {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(CLOSED.class, "/ T9_Disc_Req := TRUE;")
			};
		}
	}
	
	public static class Junction1 extends JunctionVertex {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(Junction0.class, "[D10_Error] /"),
				new Outgoing(UP.class, "[not D10_Error] / T4_SCP_Connection_Established := TRUE; T8_HB := TRUE;")
			};
		}
	}
	
	public static class Junction2 extends JunctionVertex {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(CLOSED.class, "/ T5_SCP_Connection_Terminated := TRUE;")
			};
		}
	}
}

