package example.pdi;

import lib.asal.ASALDataType;
import lib.behave.*;

/**
 * Page 48.
 */
public class SCI_Adj_Sec_STD_1 extends StateMachine {
	public final static Function cOp1_init = new Function(ASALDataType.VOID,
		"D50_PDI_Connection_State := \"\";",
		"T12_Terminate_SCP_Connection := FALSE;",
		"T7_Cd_PDI_Version_Check := FALSE;",
		"DT7_PDI_Version := \"\";",
		"T8_Cd_Initialisation_Request := FALSE;",
		"T6_Establish_SCP_Connection := FALSE;"
	);
	
	public static class Initial0 extends InitialVertex {
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(PDI_CONNECTION_CLOSED.class, "/ cOp1_Init();")
			};
		}
	}
	
	public static class PDI_CONNECTION_CLOSED extends State {
		@Override
		public LocalTransition onEntry() {
			return new LocalTransition(
				"Entry /",
				"D50_PDI_Connection_State := \"CLOSED\";",
				"T6_Establish_SCP_Connection := TRUE;"
			);
		}
		
		@Override
		public Outgoing[] getOutgoing() {
			return new Outgoing[] {
				new Outgoing(ESTABLISHING_PDI_CONNECTION.class, "when(T5_SCP_Connection_Established) /")
			};
		}
		
		@Override
		public Incoming[] getIncoming() {
			return new Incoming[] {
				new Incoming(ESTABLISHING_PDI_CONNECTION.class, "when(T10_SCP_Connection_Terminated) /"),
				new Incoming(PDI_CONNECTION_ESTABLISHED.class, "when(T10_SCP_Connection_Terminated) /"),
				new Incoming(PDI_PROTOCOL_ERROR.class, "when(T10_SCP_Connection_Terminated) /")
			};
		}
	}
	
	public static class ESTABLISHING_PDI_CONNECTION extends CompositeState {
		public static class Initial1 extends InitialVertex {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(ESTABLISHING_PDI_CONNECTION.class, "/ T7_Cd_PDI_Version_Check := TRUE;")
				};
			}
		}
		
		public static class Junction0 extends JunctionVertex {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(Junction1.class,
						"[DT7_PDI_Version = D3_Con_PDI_Version] /"
					),
					new Outgoing(Junction2.class,
						"[DT7_PDI_Version <> D3_Con_PDI_Version] /"
					)
				};
			}
		}
		
		public static class Junction1 extends JunctionVertex {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(PDI_VERSION_UNEQUAL.class,
						"[D23_Con_Checksum_Data_Used] /",
						"DT13a_Result := \"not match\";",
						"DT13b_Checksum_Data := D4_Con_Checksum_Data;",
						"T13_Msg_PDI_Version_Check := TRUE;"
					),
					new Outgoing(PDI_VERSION_UNEQUAL.class,
						"[NOT D23_Con_Checksum_Data_Used] /",
						"DT13a_Result := \"not match\";",
						"DT13b_Checksum_Data := \"not applicable\";",
						"T13_Msg_PDI_Version_Check := TRUE;"
					)
				};
			}
		}
		
		public static class Junction2 extends JunctionVertex {
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(WAITING_FOR_INITIALISATION.class,
						"[NOT D23_Con_Checksum_Data_Used] /",
						"DT13a_Result := \"match\";",
						"DT13b_Checksum_Data := \"not applicable\";",
						"T13_Msg_PDI_Version_Check := TRUE;"
					),
					new Outgoing(WAITING_FOR_INITIALISATION.class,
						"[D23_Con_Checksum_Data_Used] /",
						"DT13a_Result := \"match\";",
						"DT13b_Checksum_Data := D4_Con_Checksum_Data;",
						"T13_Msg_PDI_Version_Check := TRUE;"
					)
				};
			}
		}
		
		public static class WAITING_FOR_INITIALISATION extends State {
			@Override
			public LocalTransition onEntry() {
				return new LocalTransition(
					"Entry /",
					"D50_PDI_Connection_State := \"WAITING_FOR_INITIALISATION\";"
				);
			}
			
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(REPORTING_STATUS.class,
						"when(T8_Cd_Initialisation_Request) /",
						"T14_Msg_PDI_Version_Check := TRUE;"
					)
				};
			}
		}
		
		public static class REPORTING_STATUS extends State {
			@Override
			public LocalTransition onEntry() {
				return new LocalTransition(
					"Entry /",
					"D50_PDI_Connection_State := \"REPORTING_STATUS\";",
					"T6_Start_Status_Report := TRUE;"
				);
			}
			
			@Override
			public Outgoing[] getOutgoing() {
				return new Outgoing[] {
					new Outgoing(PDI_CONNECTION_ESTABLISHED.class,
						"when(T17_Status_Report_Completed) /",
						"T15_Msg_Initialisation_Completed := TRUE;"
					)
				};
			}
		}
	}
	
	public static class PDI_CONNECTION_ESTABLISHED extends State {
		@Override
		public LocalTransition onEntry() {
			return new LocalTransition(
				"Entry /",
				"D50_PDI_Connection_State := \"IMPERMISSIBLE\";"
			);
		}
	}
	
	public static class PDI_CONNECTION_IMPERMISSIBLE extends State {
		@Override
		public LocalTransition onEntry() {
			return new LocalTransition(
				"Entry /",
				"D50_PDI_Connection_State := \"IMPERMISSIBLE\";"
			);
		}
		
		@Override
		public Incoming[] getIncoming() {
			return new Incoming[] {
				new Incoming(PDI_VERSION_UNEQUAL.class, "when(T10_SCP_Connection_Terminated) /"),
				new Incoming(PDI_TELEGRAM_ERROR.class, "when(T10_SCP_Connection_Terminated) /")
			};
		}
	}
	
	public static class PDI_VERSION_UNEQUAL extends State {
		@Override
		public LocalTransition onEntry() {
			return new LocalTransition(
				"Entry /",
				"D50_PDI_Connection_State := \"VERSION_UNEQUAL\";",
				"T12_SCP_Terminate_SCP_Connection := TRUE;"
			);
		}
	}
	
	public static class PDI_PROTOCOL_ERROR extends State {
		@Override
		public LocalTransition onEntry() {
			return new LocalTransition(
				"Entry /",
				"D50_PDI_Connection_State := \"PROTOCOL_ERROR\";",
				"T12_SCP_Terminate_SCP_Connection := TRUE;"
			);
		}
		
		@Override
		public Incoming[] getIncoming() {
			return new Incoming[] {
				new Incoming(ESTABLISHING_PDI_CONNECTION.class, "after(T20_Protocol_Error) /")
			};
		}
	}
	
	public static class PDI_TELEGRAM_ERROR extends State {
		@Override
		public LocalTransition onEntry() {
			return new LocalTransition(
				"Entry /",
				"D50_PDI_Connection_State := \"TELEGRAM_ERROR\";",
				"T12_SCP_Terminate_SCP_Connection := TRUE;"
			);
		}
		
		@Override
		public Incoming[] getIncoming() {
			return new Incoming[] {
				new Incoming(ESTABLISHING_PDI_CONNECTION.class, "when(T21_Formal_Telegram_Error) /"),
				new Incoming(PDI_CONNECTION_ESTABLISHED.class, "when(T21_Formal_Telegram_Error) /"),
				new Incoming(ESTABLISHING_PDI_CONNECTION.class, "when(T22_Content_Telegram_Error) /"),
				new Incoming(PDI_CONNECTION_ESTABLISHED.class, "when(T22_Content_Telegram_Error) /")
			};
		}
	}
}
