package example.pdi;

import lib.blocks.ibd2.*;

/**
 * Generic interface and subsystem requirements (v3.1/2A)
 * Page 10
 */
public class EULYNX_Field_Element_Subsystem_SR extends IBD2Target {
	public final F_SCI_EfeS_Sec_SR sec = new F_SCI_EfeS_Sec_SR();
	public final F_EST_EfeS_SR est = new F_EST_EfeS_SR();
	public final F_SMI_EfeS_SR smi = new F_SMI_EfeS_SR();
	
	public final InterfacePort SMI_XX = new InterfacePort("Subsystem_MDM_M");
	public final InterfacePort SCI_XX = new InterfacePort("Subsystem_Electronic_Interlocking");
	
	public final InterfacePort SAP_SubS_EIL = new InterfacePort();
	
	@Override
	public void connectFlows() {
		est.T21_Ready_For_PDI_Connection.connect(sec.T1_Ready_For_PDI_Connection);
		est.T9_PDI_Connection_Established.connect(sec.T11_PDI_Connection_Established);
		est.T10_PDI_Connection_Closed.connect(sec.T17_PDI_Connection_Closed);
		est.T18_Not_Ready_For_PDI_Connection.connect(sec.T18_Not_Ready_For_PDI_Connection);
		
		smi.T13_Data_Update_Stop.connect(est.T22_Data_Update_Stop);
		smi.T15_Data_Update_Finished.connect(est.T17_Data_Update_Finished);
		smi.T11_Data_Update_After_Booting.connect(est.T13_Data_Update_After_Booting);
		smi.T12_Data_Update_After_Operational.connect(est.T14_Data_Update_After_Operational);
		smi.T18_Data_Update_In_Initialising.connect(est.T15_Data_Update_In_Initialising);
		smi.T5_Data_installation_item_i_finished.connect(est.T16_Data_Installation_Complete);
		
		smi.T1_Maintaining_finished.connect(SMI_XX);
		smi.T2_Preload_item_i_started.connect(SMI_XX);
		smi.T3_Preload_item_i_finished.connect(SMI_XX);
		smi.T4_Activating_item_i.connect(SMI_XX);
		smi.T6_Update_process_aborted.connect(SMI_XX);
		smi.T10_Operation_State.connect(SMI_XX);
		smi.DT10_State.connect(SMI_XX);
		smi.T9_Activation_State.connect(SMI_XX);
		smi.DT9_State.connect(SMI_XX);
		smi.T8_Preload_State.connect(SMI_XX);
		smi.DT8_State.connect(SMI_XX);
		
		sec.T7_Cd_PDI_Version_Check.connect(SCI_XX);
		sec.DT7_PDI_Version.connect(SCI_XX);
		sec.T13_Msg_PDI_Version_Check.connect(SCI_XX);
		sec.DT13a_Result.connect(SCI_XX);
		sec.DT13b_Checksum_Data.connect(SCI_XX);
		sec.T8_Cd_Initialisation_Request.connect(SCI_XX);
		sec.T14_Msg_Start_Initialisation.connect(SCI_XX);
		sec.T15_Msg_Initialisation_Completed.connect(SCI_XX);
	}
}
