# Data supporting "Boundary layers in turbulent vertical convection at high Prandtl number"

This zipped folder contains the data and notebooks necessary to re-construct figures used in the Journal of Fluid Mechanics publication linked to by the Resource DOI.

The folder `afidtools` provides a Python module from which a range of helper functions are used in the notebooks.
The folder `data` contains CSV formatted data, with the `_time_series.csv` files containing volume-averaged time series data for each simulation and the `_mean_profs.csv` files containing time- and spatially-averaged profiles in the wall-normal direction.
`thesis.mplstyle` is a matplotlib style file applied to the figures.
Each `xx.ipynb` file is a Jupyter notebook to be run using a Python kernel.
The notebooks starting with `py_collect_` are provided to highlight how the CSV formatted data was produced from the original simulation data, which is omitted from this dataset.
The rest of the notebooks use the CSV files in `data` to produce the figures of the manuscript.
All code in the notebooks is briefly documented using Markdown cells.

The original simulations were performed using `AFiD-MuRPhFi`, which is currently held on a private GitHub repository, but it will soon be made public at [https://github.com/chowland/AFiD-MuRPhFi](https://github.com/chowland/AFiD-MuRPhFi).
If you require the code before its public launch, or would like access to some of the original output data from the simulations, please contact Chris Howland at [c.j.howland@outlook.com](mailto:c.j.howland@outlook.com).