# Title

Data underlying the publication: Mining extremal property from a large 2D truss metamaterial database

## File names

  -  Dataset S1 (Dataset S1_Architecture database.csv). Entire architecture database of the designed metamaterials, including coordinates of flattened node-sets and elements of flattened adjacency matrices within building blocks.
  -  SubDataset for architectural architectures ("group name"-architectures.csv). Eleven separated databases correspond to eleven metamaterial groups for convenient access.

  -  Dataset S2 (Dataset S2_Mechanical property database.csv). Mechanical property database including Young's moduli, Poisson's ratios, shear modulus, and isotropy index.
  -  SubDataset for mechanical property ("group name"-mechanical property.csv). Eleven separated databases correspond to eleven metamaterial groups for convenient access.

## Column headings

  -  name: nomenclature for truss metamaterials generated by generic method.
  -  node#_x: 5 x-coordinates of the nodes in building blocks to construct metamaterials.
  -  node#_y: 5 y-coordinates of the nodes in building blocks to construct metamaterials.
  -  element_#: 25 elements in connectivity matrices to determine struts in building blocks.
  -  number: serial numbers of metamaterials generated based on the same group and number of struts.
  -  group: plane crystallographic groups corresponding to metamaterials.
  -
  
  -  ex: effective Young's modulus in the horizontal direction.
  -  ey: effective Young's modulus in the vertical direction.
  -  uxy: Poisson's ratio in the horizontal direction.
  -  uyx: Poisson's ratio in the vertical direction.
  -  g: effective shear modulus.
  -  Isotropy: anisotropy index to evaluate anisotropy.

## Access information

The dataset is intended for reviews of potential publication and should not be cited or used before public publication.
