### Clear memory 
rm(list = ls()) 
### Load Apollo library 
library(apollo) 
### Initialise code 
apollo_initialise() 
### Set core controls 
apollo_control = list( modelName ="AV Time-use data", modelDescr ="MDCEV with outside good and parametrised utilities", indivID ="indivID" ) 

# ########## # #### LOAD DATA AND APPLY ANY TRANSFORMATIONS #### # ############ # 
setwd(dirname(rstudioapi::getActiveDocumentContext()$path)) #set working directory in RStudio
database = read.csv("Survey_data_MDCEV_stationary_model.csv",header=TRUE) 
database$outside = rowSums(database[,c("t_a05_s", "t_a06_s", "t_a08_s", "t_a09_s", "t_a10", "gaps_in_schedule","correction")])

############ # #### DEFINE MODEL PARAMETERS #### # ##############################
### # ### Vector of parameters, including any that are kept fixed in estimation 
apollo_beta = c(alpha_base = 0, 
                gamma_sleep = 1, 
                gamma_sleep_PT = 0, 
                gamma_sleep_female = 0, 
                gamma_sleep_age1 = 0, 
                gamma_sleep_age2 = 0, 
                gamma_sleep_age3 = 0, 
                gamma_sleep_age4 = 0, 
                gamma_sleep_age56 = 0, 
                gamma_sleep_TT2 = 0, 
                gamma_sleep_TT3 = 0, 
                gamma_sleep_young_child = 0, 
                gamma_sleep_act = 0, 
                gamma_sleep_single = 0, 
                gamma_sleep_student = 0, 
                gamma_sleep_entrepreneur = 0, 
                gamma_sleep_high_edu = 0, 
                gamma_sleep_high_inc = 0,
                gamma_sleep_AV = 0, 
                gamma_sleep_PT_AV = 0, 
                gamma_sleep_act_AV = 0, 
                gamma_sleep_female_AV = 0, 
                gamma_sleep_age1_AV = 0, 
                gamma_sleep_age2_AV = 0, 
                gamma_sleep_age3_AV = 0, 
                gamma_sleep_age4_AV = 0, 
                gamma_sleep_age56_AV = 0, 
                gamma_sleep_TT2_AV = 0, 
                gamma_sleep_TT3_AV = 0, 
                gamma_sleep_young_child_AV = 0, 
                gamma_sleep_single_AV = 0, 
                gamma_sleep_student_AV = 0, 
                gamma_sleep_entrepreneur_AV = 0, 
                gamma_sleep_high_edu_AV = 0, 
                gamma_sleep_high_inc_AV = 0,
                
                gamma_get_ready = 1, 
                gamma_get_ready_PT = 0, 
                gamma_get_ready_female = 0, 
                gamma_get_ready_age1 = 0, 
                gamma_get_ready_age2 = 0, 
                gamma_get_ready_age3 = 0, 
                gamma_get_ready_age4 = 0, 
                gamma_get_ready_age56 = 0, 
                gamma_get_ready_TT2 = 0, 
                gamma_get_ready_TT3 = 0, 
                gamma_get_ready_young_child = 0, 
                gamma_get_ready_act = 0, 
                gamma_get_ready_single = 0, 
                gamma_get_ready_student = 0,  
                gamma_get_ready_entrepreneur = 0, 
                gamma_get_ready_high_edu = 0, 
                gamma_get_ready_high_inc = 0,
                gamma_get_ready_AV = 0, 
                gamma_get_ready_PT_AV = 0, 
                gamma_get_ready_act_AV = 0, 
                gamma_get_ready_female_AV = 0, 
                gamma_get_ready_age1_AV = 0, 
                gamma_get_ready_age2_AV = 0, 
                gamma_get_ready_age3_AV = 0, 
                gamma_get_ready_age4_AV = 0, 
                gamma_get_ready_age56_AV = 0, 
                gamma_get_ready_TT2_AV = 0, 
                gamma_get_ready_TT3_AV = 0, 
                gamma_get_ready_young_child_AV = 0, 
                gamma_get_ready_single_AV = 0, 
                gamma_get_ready_student_AV = 0,  
                gamma_get_ready_entrepreneur_AV = 0, 
                gamma_get_ready_high_edu_AV = 0, 
                gamma_get_ready_high_inc_AV = 0,
                
                gamma_work = 1, 
                gamma_work_PT = 0, 
                gamma_work_female = 0, 
                gamma_work_age2 = 0, 
                gamma_work_age3 = 0, 
                gamma_work_age4 = 0, 
                gamma_work_age56 = 0, 
                gamma_work_age36 = 0, 
                gamma_work_TT2 = 0, 
                gamma_work_TT3 = 0, 
                gamma_work_young_child = 0, 
                gamma_work_act = 0, 
                gamma_work_single = 0, 
                gamma_work_student = 0, 
                gamma_work_entrepreneur = 0, 
                gamma_work_high_edu = 0, 
                gamma_work_high_inc = 0,
                gamma_work_AV = 0, 
                gamma_work_PT_AV = 0,
                gamma_work_act_AV = 0,  
                gamma_work_female_AV = 0, 
                gamma_work_age36_AV = 0, 
                gamma_work_TT2_AV = 0, 
                gamma_work_TT3_AV = 0, 
                gamma_work_young_child_AV = 0, 
                gamma_work_single_AV = 0, 
                gamma_work_student_AV = 0, 
                gamma_work_entrepreneur_AV = 0, 
                gamma_work_high_edu_AV = 0, 
                gamma_work_high_inc_AV = 0,
                
                gamma_meal = 1, 
                gamma_meal_PT = 0, 
                gamma_meal_female = 0, 
                gamma_meal_age2 = 0, 
                gamma_meal_age3 = 0, 
                gamma_meal_age4 = 0, 
                gamma_meal_age56 = 0, 
                gamma_meal_TT2 = 0, 
                gamma_meal_TT3 = 0, 
                gamma_meal_young_child = 0, 
                gamma_meal_act = 0, 
                gamma_meal_single = 0, 
                gamma_meal_student = 0, 
                gamma_meal_entrepreneur = 0, 
                gamma_meal_high_edu = 0, 
                gamma_meal_high_inc = 0,
                gamma_meal_AV = 0, 
                gamma_meal_PT_AV = 0, 
                gamma_meal_act_AV = 0, 
                gamma_meal_female_AV = 0, 
                gamma_meal_age1_AV = 0, 
                gamma_meal_TT2_AV = 0, 
                gamma_meal_TT3_AV = 0, 
                gamma_meal_young_child_AV = 0, 
                gamma_meal_single_AV = 0, 
                gamma_meal_student_AV = 0, 
                gamma_meal_entrepreneur_AV = 0, 
                gamma_meal_high_edu_AV = 0, 
                gamma_meal_high_inc_AV = 0,
                
                gamma_leisure = 1, 
                gamma_leisure_PT = 0, 
                gamma_leisure_female = 0, 
                gamma_leisure_age1 = 0, 
                gamma_leisure_age2 = 0, 
                gamma_leisure_age3 = 0, 
                gamma_leisure_age4 = 0, 
                gamma_leisure_age56 = 0, 
                gamma_leisure_age23 = 0, 
                gamma_leisure_age46 =0, 
                gamma_leisure_TT2 = 0, 
                gamma_leisure_TT3 = 0, 
                gamma_leisure_young_child = 0, 
                gamma_leisure_high_inc = 0, 
                gamma_leisure_act = 0, 
                gamma_leisure_single = 0, 
                gamma_leisure_student = 0, 
                gamma_leisure_entrepreneur = 0, 
                gamma_leisure_high_edu = 0,
                gamma_leisure_AV = 0, 
                gamma_leisure_PT_AV = 0, 
                gamma_leisure_act_AV = 0, 
                gamma_leisure_female_AV = 0, 
                gamma_leisure_age1_AV = 0, 
                gamma_leisure_age2_AV = 0, 
                gamma_leisure_age3_AV = 0, 
                gamma_leisure_age4_AV = 0, 
                gamma_leisure_age56_AV = 0, 
                gamma_leisure_age23_AV = 0, 
                gamma_leisure_age46_AV =0, 
                gamma_leisure_TT2_AV = 0, 
                gamma_leisure_TT3_AV = 0, 
                gamma_leisure_young_child_AV = 0, 
                gamma_leisure_high_inc_AV = 0, 
                gamma_leisure_single_AV = 0, 
                gamma_leisure_student_AV = 0, 
                gamma_leisure_entrepreneur_AV = 0, 
                gamma_leisure_high_edu_AV = 0,
                
                delta_sleep_work = 1, 
                delta_get_ready = 0, 
                delta_get_ready_PT = 0, 
                delta_get_ready_female = 0, 
                delta_get_ready_age2 = 0, 
                delta_get_ready_age3 = 0, 
                delta_get_ready_age4 = 0, 
                delta_get_ready_age56 = 0, 
                delta_get_ready_TT2 = 0, 
                delta_get_ready_TT3 = 0, 
                delta_get_ready_young_child = 0, 
                delta_get_ready_act = 0, 
                delta_get_ready_single = 0, 
                delta_get_ready_student = 0, 
                delta_get_ready_entrepreneur = 0, 
                delta_get_ready_high_edu = 0, 
                delta_get_ready_high_inc = 0,
                delta_get_ready_AV = 0, 
                delta_get_ready_PT_AV = 0, 
                delta_get_ready_act_AV = 0, 
                delta_get_ready_female_AV = 0, 
                delta_get_ready_TT2_AV = 0, 
                delta_get_ready_TT3_AV = 0, 
                delta_get_ready_young_child_AV = 0, 
                delta_get_ready_single_AV = 0, 
                delta_get_ready_student_AV = 0, 
                delta_get_ready_entrepreneur_AV = 0, 
                delta_get_ready_high_edu_AV = 0, 
                delta_get_ready_high_inc_AV = 0,
                
                delta_meal = 0, 
                delta_meal_PT = 0, 
                delta_meal_female = 0, 
                delta_meal_age24 = 0, 
                delta_meal_age56 = 0, 
                delta_meal_TT2 = 0, 
                delta_meal_TT3 = 0, 
                delta_meal_young_child = 0, 
                delta_meal_act = 0, 
                delta_meal_single = 0, 
                delta_meal_student = 0, 
                delta_meal_entrepreneur = 0, 
                delta_meal_high_edu = 0, 
                delta_meal_high_inc = 0,
                delta_meal_AV = 0, 
                delta_meal_PT_AV = 0, 
                delta_meal_act_AV = 0, 
                delta_meal_female_AV = 0, 
                delta_meal_age1_AV = 0, 
                delta_meal_age56_AV = 0, 
                delta_meal_TT2_AV = 0, 
                delta_meal_TT3_AV = 0,
                delta_meal_young_child_AV = 0, 
                delta_meal_single_AV = 0, 
                delta_meal_student_AV = 0, 
                delta_meal_entrepreneur_AV = 0, 
                delta_meal_high_edu_AV = 0, 
                delta_meal_high_inc_AV = 0,
                
                delta_leisure = 0, 
                delta_leisure_PT = 0, 
                delta_leisure_female = 0, 
                delta_leisure_age2 = 0, 
                delta_leisure_age3 = 0, 
                delta_leisure_age4 = 0, 
                delta_leisure_age56 = 0, 
                delta_leisure_TT2 = 0, 
                delta_leisure_TT3 = 0, 
                delta_leisure_young_child = 0, 
                delta_leisure_high_inc = 0, 
                delta_leisure_act = 0, 
                delta_leisure_single = 0, 
                delta_leisure_student = 0, 
                delta_leisure_entrepreneur = 0, 
                delta_leisure_high_edu = 0, 
                delta_leisure_AV = 0, 
                delta_leisure_PT_AV = 0, 
                delta_leisure_act_AV = 0, 
                delta_leisure_female_AV = 0, 
                delta_leisure_age2_AV = 0, 
                delta_leisure_age3_AV = 0, 
                delta_leisure_age4_AV = 0, 
                delta_leisure_age56_AV = 0, 
                delta_leisure_TT2_AV = 0, 
                delta_leisure_TT3_AV = 0,
                delta_leisure_young_child_AV = 0, 
                delta_leisure_high_inc_AV = 0, 
                delta_leisure_single_AV = 0, 
                delta_leisure_student_AV = 0, 
                delta_leisure_entrepreneur_AV = 0, 
                delta_leisure_high_edu_AV = 0, 
                
                sigma = 1
                ) 
### Vector with names (in quotes) of parameters to be kept fixed at their starting value in apollo_beta, use 
apollo_beta_fixed = c() ##if none 
#apollo_fixed = c("delta_other4", "gamma_other4", "alpha_base")
apollo_fixed = c("delta_sleep_work","sigma",
                 
                  "gamma_sleep_female",
                 "gamma_sleep_age1", 
                 "gamma_sleep_age2",
                  "gamma_sleep_age3",
                  "gamma_sleep_age4",
                  "gamma_sleep_age56",
                  #"gamma_sleep_act", 
                  "gamma_sleep_single",
                  "gamma_sleep_high_edu",
                 "gamma_sleep_high_inc",
                 "gamma_sleep_student",
                 "gamma_sleep_PT",
                 
                  "gamma_sleep_female_AV",
                  "gamma_sleep_age1_AV", 
                  "gamma_sleep_age2_AV",
                  "gamma_sleep_age3_AV",
                   "gamma_sleep_age4_AV",
                   "gamma_sleep_age56_AV",
                  "gamma_sleep_single_AV",
                  "gamma_sleep_high_edu_AV",
                  "gamma_sleep_high_inc_AV",
                  "gamma_sleep_student_AV",
                  "gamma_sleep_young_child_AV",
                 "gamma_sleep_PT_AV",
                 "gamma_sleep_act_AV",
                 "gamma_sleep_TT2_AV",
                 "gamma_sleep_TT3_AV",
                 
                  "gamma_get_ready_female",
                 "gamma_get_ready_age1",
                 "gamma_get_ready_age2", 
                 "gamma_get_ready_age3",
                  "gamma_get_ready_age4",
                  "gamma_get_ready_TT2",
                  "gamma_get_ready_single", 
                 "gamma_get_ready_young_child",
                 #"gamma_get_ready_high_edu",
                 "gamma_get_ready_high_inc",
                 "gamma_get_ready_act", 
                 "gamma_get_ready_PT",
                 
                  "gamma_get_ready_female_AV",
                  "gamma_get_ready_age1_AV",
                  "gamma_get_ready_age2_AV", 
                  "gamma_get_ready_age3_AV",
                  "gamma_get_ready_age4_AV",
                  "gamma_get_ready_age56_AV",
                  "gamma_get_ready_single_AV", 
                  "gamma_get_ready_high_edu_AV",
                  "gamma_get_ready_high_inc_AV",
                  "gamma_get_ready_student_AV",
                  "gamma_get_ready_young_child_AV",##??
                 "gamma_get_ready_PT_AV",
                 "gamma_get_ready_act_AV",
                 "gamma_get_ready_TT2_AV",
                 "gamma_get_ready_TT3_AV",
                 
                  "gamma_work_age2",
                  "gamma_work_age3",
                  "gamma_work_age4",
                  "gamma_work_age56",
                  "gamma_work_act",
                  "gamma_work_single",
                  "gamma_work_student",
                 "gamma_work_high_edu",
                 "gamma_work_high_inc",
                 "gamma_work_PT",
                 
                  "gamma_work_single_AV",
                  "gamma_work_student_AV",
                  "gamma_work_high_edu_AV",
                  "gamma_work_high_inc_AV",
                  "gamma_work_female_AV",
                  "gamma_work_age36_AV",
                  "gamma_work_young_child_AV",
                 "gamma_work_PT_AV",
                 "gamma_work_act_AV",
                 "gamma_work_TT2_AV",
                 "gamma_work_TT3_AV",
                 
                  "gamma_meal_age2",
                  "gamma_meal_age3",
                  "gamma_meal_age4",
                 "gamma_meal_age56",
                  "gamma_meal_TT2",
                  "gamma_meal_TT3",
                  "gamma_meal_act",##??
                  "gamma_meal_student",
                 "gamma_meal_high_edu",
                 "gamma_meal_high_inc",
                 "gamma_meal_PT",
                  
                  "gamma_meal_age1_AV",
                  "gamma_meal_student_AV",
                  "gamma_meal_high_edu_AV",
                  "gamma_meal_high_inc_AV",
                  "gamma_meal_young_child_AV",
                  "gamma_meal_female_AV",
                  "gamma_meal_single_AV",
                 "gamma_meal_PT_AV",
                 "gamma_meal_act_AV",
                 "gamma_meal_TT2_AV",
                 "gamma_meal_TT3_AV",
                 
                  "gamma_leisure_TT2",
                  "gamma_leisure_TT3",
                 #"gamma_leisure_age1",
                  "gamma_leisure_age2",
                  "gamma_leisure_age3",
                  "gamma_leisure_age4",
                  "gamma_leisure_age56",
                 "gamma_leisure_age23",
                 "gamma_leisure_age46",
                 #"gamma_leisure_high_edu",
                 "gamma_leisure_act",
                  "gamma_leisure_single",
                  "gamma_leisure_female",
                 "gamma_leisure_young_child",
                 "gamma_leisure_student",
                 "gamma_leisure_PT",
                 
                 "gamma_leisure_age1_AV",
                 "gamma_leisure_age2_AV",
                 "gamma_leisure_age3_AV",
                 "gamma_leisure_age4_AV",
                 "gamma_leisure_age56_AV",
                 "gamma_leisure_age23_AV",
                 "gamma_leisure_age46_AV",
                  "gamma_leisure_high_edu_AV",
                  "gamma_leisure_single_AV",
                  "gamma_leisure_female_AV",
                 # "gamma_leisure_young_child_AV",##??
                  "gamma_leisure_student_AV",
                  "gamma_leisure_high_inc_AV",
                 "gamma_leisure_PT_AV",
                 "gamma_leisure_act_AV",
                 "gamma_leisure_TT2_AV",
                 "gamma_leisure_TT3_AV",
                 
                  "delta_get_ready_age2",
                  "delta_get_ready_age3",
                  "delta_get_ready_age4",
                  "delta_get_ready_student",
                  "delta_get_ready_young_child",
                 "delta_get_ready_high_edu",
                 "delta_get_ready_high_inc",
                  "delta_get_ready_act",
                 "delta_get_ready_PT",##??
                 
                  "delta_get_ready_student_AV",
                  "delta_get_ready_young_child_AV",
                #  "delta_get_ready_high_edu_AV",
                  "delta_get_ready_high_inc_AV",
                 "delta_get_ready_female_AV",
                  "delta_get_ready_single_AV",
                 "delta_get_ready_PT_AV",
                 "delta_get_ready_act_AV",
                "delta_get_ready_TT2_AV",
                "delta_get_ready_TT3_AV",
                 
                  "delta_meal_single",
                  "delta_meal_student",
                  # "delta_meal_act",
                 "delta_meal_high_edu",
                  "delta_meal_age56",
                 "delta_meal_high_inc",
                 "delta_meal_age24",
                 "delta_meal_PT", 
                
                  "delta_meal_single_AV",
                  "delta_meal_student_AV",
                  "delta_meal_high_edu_AV",
                 # "delta_meal_age56_AV",
                  "delta_meal_high_inc_AV",
                #  "delta_meal_age1_AV",
                  "delta_meal_young_child_AV",
                  "delta_meal_female_AV",
                "delta_meal_PT_AV",
                 "delta_meal_act_AV",
                "delta_meal_TT2_AV",
                "delta_meal_TT3_AV",
                
                  "delta_leisure_age2",
                  "delta_leisure_age3",
                  "delta_leisure_age4",
                  "delta_leisure_age56",
                  "delta_leisure_single", 
                  "delta_leisure_student",
                 "delta_leisure_high_edu",
                  "delta_leisure_act",
                "delta_leisure_PT",
                 
                  "delta_leisure_age2_AV",
                  "delta_leisure_age3_AV",
                 # "delta_leisure_age4_AV",
                #  "delta_leisure_age56_AV",
                 # "delta_leisure_single_AV", 
                  "delta_leisure_student_AV",
                  "delta_leisure_high_edu_AV",
                  "delta_leisure_female_AV",
                  "delta_leisure_young_child_AV",
                  "delta_leisure_high_inc_AV",
                 "delta_leisure_PT_AV",
                 "delta_leisure_act_AV",
                "delta_leisure_TT2_AV",
                "delta_leisure_TT3_AV",
                  
                  # 
                  # "gamma_sleep_AV",
                  # "gamma_get_ready_AV",
                  # "gamma_work_AV",
                  # "gamma_meal_AV",
                  # "gamma_leisure_AV",
                  # "delta_get_ready_AV",
                  # "delta_meal_AV",
                  # "delta_leisure_AV"
                  # 
                 #Found significant
                 #"gamma_sleep_TT2","gamma_sleep_TT3","gamma_sleep_young_child",
                 #"gamma_get_ready_student",
                 #"gamma_work_female","gamma_work_age36","gamma_work_TT2","gamma_work_TT3","gamma_work_young_child",
                 #"gamma_meal_young_child",
                 #"gamma_leisure_high_inc",
                 #"delta_get_ready_female","delta_get_ready_age56","delta_get_ready_TT2","delta_get_ready_TT3","delta_get_ready_single",
                 #"delta_meal_TT2","delta_meal_TT3","delta_meal_young_child",
                 #"delta_leisure_female","delta_leisure_TT2","delta_leisure_TT3","delta_leisure_young_child","delta_leisure_high_inc"
                 
                 
                 #Found significant second round
                 #
                 # "gamma_get_ready_age56",
                # "gamma_get_ready_TT3",
                 # "gamma_meal_female",
                 # "gamma_meal_single",
                 #"gamma_leisure_age46",
                 
                  
                  #"delta_get_ready_single",
                 # "delta_meal_female"
                
                  "gamma_sleep_entrepreneur",
                  "gamma_get_ready_entrepreneur",
                 # "gamma_work_entrepreneur",
                  "gamma_meal_entrepreneur",
                  "gamma_leisure_entrepreneur",
                  "gamma_sleep_entrepreneur_AV",
                  "gamma_get_ready_entrepreneur_AV",
                  "gamma_work_entrepreneur_AV",
                  "gamma_meal_entrepreneur_AV",
                  "gamma_leisure_entrepreneur_AV",
                 
                 "delta_get_ready_entrepreneur",
                 "delta_meal_entrepreneur",
                 "delta_leisure_entrepreneur",
                 "delta_get_ready_entrepreneur_AV",
                 "delta_meal_entrepreneur_AV",
                 "delta_leisure_entrepreneur_AV"
                 
                 )


############ # #### GROUP AND VALIDATE INPUTS #### # ############################
apollo_inputs = apollo_validateInputs() 

############ # #### DEFINE MODEL AND LIKELIHOOD FUNCTION #### # #################
apollo_probabilities=function(apollo_beta, apollo_inputs, functionality="estimate")
  { ### Attach inputs and detach after function exit 
  apollo_attach(apollo_beta, apollo_inputs) 
  on.exit(apollo_detach(apollo_beta, apollo_inputs)) 
  ### Create list of probabilities P 
  P = list() 
  ### Define individual alternatives 
  alternatives = c("outside", "sleep", "get_ready", "work", "meal", "leisure") 
  ### Define availabilities 
  avail = list(outside = 1, sleep = 1, get_ready = 1, work = 1, meal = 1, leisure = 1) 
  ### Define continuous consumption for individual alternatives 
  continuousChoice = list(sleep = t_a01_s/60, get_ready = t_a02_s/60, work = t_a03_s/60, meal = t_a04_s/60, leisure = t_a07_s/60, outside = (t_a05_s + t_a06 + t_a08_s + t_a09_s + t_a10 + gaps_in_schedule + correction)/60) 
  ### Define utilities for individual alternatives 
  V = list() 
  V[["sleep" ]] = delta_sleep_work 
  V[["get_ready" ]] = delta_get_ready + delta_get_ready_AV * isAV + 
                      (delta_get_ready_PT + delta_get_ready_PT_AV * isAV) * (travelMode == 2) + 
                      (delta_get_ready_female + delta_get_ready_female_AV * isAV) * (Gender == 2) + 
                      (delta_get_ready_age2 ) * (Age_group == 2) + 
                      (delta_get_ready_age3 ) * (Age_group == 3) + 
                      (delta_get_ready_age4 ) * (Age_group == 4) + 
                      (delta_get_ready_age56 ) * (Age_group >= 5) + 
                      (delta_get_ready_TT2 + delta_get_ready_TT2_AV * isAV)  * (travelTime == 2) + 
                      (delta_get_ready_TT3 + delta_get_ready_TT3_AV * isAV)  * (travelTime ==3) + 
                      (delta_get_ready_young_child + delta_get_ready_young_child_AV * isAV) * (Family_cycle == 11) + 
                      (delta_get_ready_act + delta_get_ready_act_AV * isAV) * (travelMode >=3) + 
                      (delta_get_ready_single + delta_get_ready_single_AV * isAV) * (Family_cycle <=5) + 
                      (delta_get_ready_student + delta_get_ready_student_AV * isAV) * (Work_type ==7) + 
                      (delta_get_ready_entrepreneur + delta_get_ready_entrepreneur_AV * isAV) * (Work_type ==1) + 
                      (delta_get_ready_high_edu + delta_get_ready_high_edu_AV * isAV) * (Education >= 6) + 
                      (delta_get_ready_high_inc + delta_get_ready_high_inc_AV * isAV) * (Income_group >=6)
  V[["work" ]] = delta_sleep_work 
  V[["meal"]] = delta_meal  + delta_meal_AV * isAV + 
                      (delta_meal_PT + delta_meal_PT_AV * isAV) * (travelMode == 2) + 
                      (delta_meal_female + delta_meal_female_AV * isAV) * (Gender == 2) + 
                      delta_meal_age1_AV * isAV * (Age_group == 1) + 
                      delta_meal_age24 * (Age_group >= 2) * (Age_group <= 4) + 
                      (delta_meal_age56 + delta_meal_age56_AV * isAV) * (Age_group >= 5) + 
                      (delta_meal_TT2 + delta_meal_TT2_AV * isAV) * (travelTime == 2) + 
                      (delta_meal_TT3 + delta_meal_TT3_AV * isAV)* (travelTime ==3) + 
                      (delta_meal_young_child + delta_meal_young_child_AV * isAV) * (Family_cycle == 11) + 
                      (delta_meal_act + delta_meal_act_AV * isAV) * (travelMode >=3) + 
                      (delta_meal_single + delta_meal_single_AV * isAV) * (Family_cycle <=5) + 
                      (delta_meal_student + delta_meal_student_AV * isAV) * (Work_type ==7) + 
                      (delta_meal_entrepreneur + delta_meal_entrepreneur_AV * isAV) * (Work_type ==1) + 
                      (delta_meal_high_edu + delta_meal_high_edu_AV * isAV) * (Education >= 6) + 
                      (delta_meal_high_inc+ delta_meal_high_inc_AV * isAV) * (Income_group >=6)
  V[["leisure" ]] = delta_leisure + delta_leisure_AV * isAV + 
                      (delta_leisure_PT + delta_leisure_PT_AV * isAV) * (travelMode == 2) +
                      (delta_leisure_female + delta_leisure_female_AV * isAV) * (Gender == 2) + 
                      (delta_leisure_age2 + delta_leisure_age2_AV * isAV) * (Age_group == 2) + 
                      (delta_leisure_age3 + delta_leisure_age3_AV * isAV) * (Age_group == 3) + 
                      (delta_leisure_age4 + delta_leisure_age4_AV * isAV) * (Age_group == 4) + 
                      (delta_leisure_age56  + delta_leisure_age56_AV * isAV)* (Age_group >= 5) + 
                      (delta_leisure_TT2 + delta_leisure_TT2_AV * isAV) * (travelTime == 2) + 
                      (delta_leisure_TT3 + delta_leisure_TT3_AV * isAV)  * (travelTime ==3) + 
                      (delta_leisure_young_child + delta_leisure_young_child_AV * isAV) * (Family_cycle == 11) + 
                      (delta_leisure_high_inc + delta_leisure_high_inc_AV * isAV) * (Income_group >=6) + 
                      (delta_leisure_act + delta_leisure_act_AV * isAV) * (travelMode >=3) + 
                      (delta_leisure_single + delta_leisure_single_AV * isAV) * (Family_cycle <=5) + 
                      (delta_leisure_student + delta_leisure_student_AV * isAV) * (Work_type ==7) + 
                      (delta_leisure_entrepreneur + delta_leisure_entrepreneur_AV * isAV) * (Work_type ==1) + 
                      (delta_leisure_high_edu + delta_leisure_high_edu_AV * isAV) * (Education >= 6)
  V[["outside"]] = 0 
    ### Define alpha parameters 
  alpha = list(outside = alpha_base, sleep = alpha_base, get_ready = alpha_base, work = alpha_base, meal = alpha_base, leisure = alpha_base) 
  ### Define gamma parameters 
  gamma = list(sleep = gamma_sleep + gamma_sleep_AV * isAV + 
                      (gamma_sleep_PT + gamma_sleep_PT_AV * isAV) * (travelMode == 2) + 
                      (gamma_sleep_female + gamma_sleep_female_AV * isAV) * (Gender == 2) + 
                      (gamma_sleep_age1 + gamma_sleep_age1_AV * isAV) * (Age_group == 1) + 
                      (gamma_sleep_age2 + gamma_sleep_age2_AV * isAV) * (Age_group == 2) + 
                      (gamma_sleep_age3 + gamma_sleep_age3_AV * isAV) * (Age_group == 3) + 
                      (gamma_sleep_age4 + gamma_sleep_age4_AV * isAV) * (Age_group == 4) + 
                      (gamma_sleep_age56 + gamma_sleep_age56_AV * isAV) * (Age_group >= 5) + 
                      (gamma_sleep_TT2 + gamma_sleep_TT2_AV * isAV) * (travelTime == 2) + 
                      (gamma_sleep_TT3 + gamma_sleep_TT3_AV * isAV) * (travelTime ==3)+ 
                      (gamma_sleep_young_child + gamma_sleep_young_child_AV * isAV) * (Family_cycle == 11) + 
                      (gamma_sleep_act + gamma_sleep_act_AV * isAV) *(travelMode >=3) + 
                      (gamma_sleep_single + gamma_sleep_single_AV * isAV) * (Family_cycle <=5) + 
                      (gamma_sleep_student + gamma_sleep_student_AV * isAV) * (Work_type ==7) + 
                      (gamma_sleep_entrepreneur + gamma_sleep_entrepreneur_AV * isAV) * (Work_type ==1) + 
                      (gamma_sleep_high_edu + gamma_sleep_high_edu_AV * isAV) * (Education >= 6)+ 
                      (gamma_sleep_high_inc + gamma_sleep_high_inc_AV * isAV) * (Income_group >=6),
               get_ready = gamma_get_ready  + gamma_get_ready_AV * isAV + 
                      (gamma_get_ready_PT + gamma_get_ready_PT_AV * isAV) * (travelMode == 2) + 
                      (gamma_get_ready_female + gamma_get_ready_female_AV * isAV) * (Gender == 2) + 
                      (gamma_get_ready_age1 + gamma_get_ready_age1_AV * isAV) * (Age_group == 1) + 
                      (gamma_get_ready_age2 + gamma_get_ready_age2_AV * isAV) * (Age_group == 2) + 
                      (gamma_get_ready_age3 + gamma_get_ready_age3_AV * isAV) * (Age_group == 3) + 
                      (gamma_get_ready_age4 + gamma_get_ready_age4_AV * isAV) * (Age_group == 4) + 
                      (gamma_get_ready_age56 + gamma_get_ready_age56_AV * isAV) * (Age_group >= 5) + 
                      (gamma_get_ready_TT2 + gamma_get_ready_TT2_AV * isAV) * (travelTime == 2) + 
                      (gamma_get_ready_TT3 + gamma_get_ready_TT3_AV * isAV)  * (travelTime ==3) + 
                      (gamma_get_ready_young_child + gamma_get_ready_young_child_AV * isAV) * (Family_cycle == 11) + 
                      (gamma_get_ready_act + gamma_get_ready_act_AV * isAV)* (travelMode >=3) + 
                      (gamma_get_ready_single + gamma_get_ready_single_AV * isAV) * (Family_cycle <=5) + 
                      (gamma_get_ready_student + gamma_get_ready_student_AV * isAV) * (Work_type ==7) + 
                      (gamma_get_ready_entrepreneur + gamma_get_ready_entrepreneur_AV * isAV) * (Work_type ==1) + 
                      (gamma_get_ready_high_edu + gamma_get_ready_high_edu_AV * isAV) * (Education >= 6) + 
                      (gamma_get_ready_high_inc + gamma_get_ready_high_inc_AV * isAV) * (Income_group >=6), 
               work = gamma_work + gamma_work_AV * isAV + 
                      (gamma_work_PT + gamma_work_PT_AV * isAV) * (travelMode == 2) + 
                      (gamma_work_female + gamma_work_female_AV * isAV) * (Gender == 2) + 
                      (gamma_work_age2 ) * (Age_group == 2) + 
                      (gamma_work_age3 ) * (Age_group == 3) + 
                      (gamma_work_age4 ) * (Age_group == 4) + 
                      (gamma_work_age56 ) * (Age_group >= 5) + 
                      (gamma_work_age36 + gamma_work_age36_AV * isAV) * (Age_group >= 3) + 
                      (gamma_work_TT2 + gamma_work_TT2_AV * isAV) * (travelTime == 2) + 
                      (gamma_work_TT3 + gamma_work_TT3_AV * isAV)  * (travelTime ==3) + 
                      (gamma_work_young_child + gamma_work_young_child_AV * isAV) * (Family_cycle == 11) + 
                      (gamma_work_act + gamma_work_act_AV * isAV) * (travelMode >=3) + 
                      (gamma_work_single + gamma_work_single_AV * isAV) * (Family_cycle <=5) + 
                      (gamma_work_student + gamma_work_student_AV * isAV) * (Work_type ==7) + 
                      (gamma_work_entrepreneur + gamma_work_entrepreneur_AV * isAV) * (Work_type ==1) + 
                      (gamma_work_high_edu + gamma_work_high_edu_AV * isAV) * (Education >= 6) + 
                      (gamma_work_high_inc + gamma_work_high_inc_AV * isAV) * (Income_group >=6),
               meal = gamma_meal + gamma_meal_AV * isAV + 
                      (gamma_meal_PT + gamma_meal_PT_AV * isAV) * (travelMode == 2) + 
                      (gamma_meal_female + gamma_meal_female_AV * isAV) * (Gender == 2) + 
                      gamma_meal_age1_AV * isAV * (Age_group == 1) + 
                      gamma_meal_age56 * (Age_group >= 5) + 
                      (gamma_meal_TT2 + gamma_meal_TT2_AV * isAV) * (travelTime == 2) + 
                      (gamma_meal_TT3 + gamma_meal_TT3_AV * isAV) * (travelTime ==3) + 
                      (gamma_meal_young_child + gamma_meal_young_child_AV * isAV) * (Family_cycle == 11) + 
                      (gamma_meal_act + gamma_meal_act_AV * isAV) * (travelMode >=3) + 
                      (gamma_meal_single + gamma_meal_single_AV * isAV) * (Family_cycle <=5) + 
                      (gamma_meal_student + gamma_meal_student_AV * isAV) * (Work_type ==7) + 
                      (gamma_meal_entrepreneur + gamma_meal_entrepreneur_AV * isAV) * (Work_type ==1) + 
                      (gamma_meal_high_edu + gamma_meal_high_edu_AV * isAV) * (Education >= 6) + 
                      (gamma_meal_high_inc + gamma_meal_high_inc_AV * isAV) * (Income_group >=6), 
               leisure = gamma_leisure + gamma_leisure_AV * isAV + 
                      (gamma_leisure_PT + gamma_leisure_PT_AV * isAV) * (travelMode == 2) + 
                      (gamma_leisure_female + gamma_leisure_female_AV * isAV) * (Gender == 2) + 
                      (gamma_leisure_age1 + gamma_leisure_age1_AV * isAV) * (Age_group == 1) + 
                      (gamma_leisure_age2 + gamma_leisure_age2_AV * isAV) * (Age_group == 2) + 
                      (gamma_leisure_age3 + gamma_leisure_age3_AV * isAV) * (Age_group == 3) + 
                      (gamma_leisure_age4 + gamma_leisure_age4_AV * isAV) * (Age_group == 4) + 
                      (gamma_leisure_age56 + gamma_leisure_age56_AV * isAV) * (Age_group >= 5) + 
                      (gamma_leisure_age23 + gamma_leisure_age23_AV * isAV) * (Age_group >= 2) * (Age_group <= 3) + 
                      (gamma_leisure_age46 + gamma_leisure_age46_AV * isAV) * (Age_group >= 4) + 
                      (gamma_leisure_TT2 + gamma_leisure_TT2_AV * isAV) * (travelTime == 2) + 
                      (gamma_leisure_TT3 + gamma_leisure_TT3_AV * isAV)  * (travelTime ==3) + 
                      (gamma_leisure_young_child + gamma_leisure_young_child_AV * isAV) * (Family_cycle == 11) + 
                      (gamma_leisure_high_inc + gamma_leisure_high_inc_AV * isAV) * (Income_group >=6) + 
                      (gamma_leisure_act + gamma_leisure_act_AV * isAV) * (travelMode >=3) + 
                      (gamma_leisure_single + gamma_leisure_single_AV * isAV) * (Family_cycle <=5) + 
                      (gamma_leisure_student + gamma_leisure_student_AV * isAV) * (Work_type ==7) + 
                      (gamma_leisure_entrepreneur + gamma_leisure_entrepreneur_AV * isAV) * (Work_type ==1) + 
                      (gamma_leisure_high_edu + gamma_leisure_high_edu_AV * isAV) * (Education >= 6), 
               outside = 1) 
  ### Define costs for individual alternatives 
  cost = list(outside = 1, sleep = 1, get_ready = 1, work = 1, meal = 1, leisure = 1) 
  ### Define budget 
  budget = budget / 60
  ### Define settings for MDCEV model 
  mdcev_settings <- list(alternatives = alternatives, avail = avail, continuousChoice = continuousChoice, V = V, alpha = alpha, gamma = gamma, sigma = sigma, cost = cost, budget = budget) 
  ### Compute probabilities using MDCEV model 
  P[["model"]] = apollo_mdcev(mdcev_settings, functionality) 
  ### Take product across observation for same individual 
  P = apollo_panelProd(P, apollo_inputs, functionality) 
  ### Prepare and return outputs of function 
  P = apollo_prepareProb(P, apollo_inputs, functionality) 
  return(P) } 


################# # #### MODEL ESTIMATION #### # ########################## # 
model = apollo_estimate(apollo_beta, apollo_fixed, apollo_probabilities, apollo_inputs) 

################# # #### MODEL OUTPUTS #### # ############################# # 
#------ # #---- FORMATTED OUTPUT (TO SCREEN) ---- # ---------------------------- # 
options(max.print=999999)
apollo_modelOutput(model) 

#########---- FORMATTED OUTPUT (TO FILE, using model name) ---- ------------- # 
# apollo_saveOutput(model) 

# ################### # ##### POST-PROCESSING #### # ############ 
# ### Print outputs of additional diagnostics to new output file (remember to close file writing when complete) 
# sink(paste(model$apollo_control$modelName,"_additional_output.txt",sep=""),split=TRUE) 
# ------------------ # #---- MODEL PREDICTIONS ---- # -------------------- 
# ### Use the estimated model to make predictions 
predictions_base = apollo_prediction(model, apollo_probabilities, apollo_inputs) 
colMeans(predictions_base) # ----- # 
#---- switch off writing to file ---- ---------- # 
#if(sink.number()>0) 
#  sink()