#install.packages("ggpubr")
#library("ggpubr")
#library(corrplot)


database = read.csv("Survey_data_MDCEV_stationary_model.csv",header=TRUE) 
database$other_stationary = rowSums(database[,c("t_a05_s", "t_a06_s", "t_a08_s", "t_a09_s")])
database$other_on_board = rowSums(database[,c("t_a01_o", "t_a05_o", "t_a06_o", "t_a08_o", "t_a09_o")])
n = 496 #number of respondents in the dataset

vect_stat <- paste0("t_a0",c(1:4,7),"_s") #vector of stationary activity names
vect_stat[6]<-"other_stationary"
vect_stat[7]<-"t_a10"
vect_stat_titles <-c("Sleep","Get ready","Work","Meal","Leisure","Other","Travel")
vect_onb <- paste0("t_a0",c(2:4,7),"_o") #vector of on-board activity names
vect_onb[5]<-"other_on_board"
vect_onb[6]<-"t_a11_o" #do nothing
vect_onb_titles <-c("Get ready","Work","Meal","Leisure","Other","Do nothing")


#DESCRIPTIVES: SELECTION, MEAN, ST.DEV. OF EACH ACTIVITY, SPLIT BY TRAVEL MODE USERS
mode_users <-c() #number of users of each travel mode (with some modes joined)
mode_users[1] <- length(database[which(database[,c("Mode")]=="Car_driver" | database[,c("Mode")]=="Car_pax"),1])
mode_users[2] <- length(database[which(database[,c("Mode")]=="PT"),1])
mode_users[3] <- length(database[which(database[,c("Mode")]=="Bike" | database[,c("Mode")]=="Walk"),1])
mode_users[4] <- length(database[which(database[,c("Mode")]=="AV_partial"),1])
mode_users[5] <- length(database[which(database[,c("Mode")]=="AV_ideal"),1])
mode_users

#For stationary activities
sel = matrix(0, nrow = 5, ncol = 7) #matrix for % of mode users who selected each activity
dur = matrix(0, nrow = 5, ncol = 7) #matrix for average activity durations among those who selected it
std = matrix(0, nrow = 5, ncol = 7) #matrix for st.dev. of activity durations among those who selected it
for (i in 1:7){
  sel[1,i] <- length(database[which(database[,vect_stat[i]]!=0 & (database[,c("Mode")]=="Car_driver" | database[,c("Mode")]=="Car_pax")),vect_stat[i]])/mode_users[1]
  sel[2,i] <- length(database[which(database[,vect_stat[i]]!=0 & database[,c("Mode")]=="PT"),vect_stat[i]])/mode_users[2]
  sel[3,i] <- length(database[which(database[,vect_stat[i]]!=0 & (database[,c("Mode")]=="Bike" | database[,c("Mode")]=="Walk")),vect_stat[i]])/mode_users[3]
  sel[4,i] <- length(database[which(database[,vect_stat[i]]!=0 & database[,c("Mode")]=="AV_partial"),vect_stat[i]])/mode_users[4]
  sel[5,i] <- length(database[which(database[,vect_stat[i]]!=0 & database[,c("Mode")]=="AV_ideal"),vect_stat[i]])/mode_users[5]

  dur[1,i] <- mean(database[which(database[,vect_stat[i]]!=0 & (database[,c("Mode")]=="Car_driver" | database[,c("Mode")]=="Car_pax")),vect_stat[i]])
  dur[2,i] <- mean(database[which(database[,vect_stat[i]]!=0 & database[,c("Mode")]=="PT"),vect_stat[i]])
  dur[3,i] <- mean(database[which(database[,vect_stat[i]]!=0 & (database[,c("Mode")]=="Bike" | database[,c("Mode")]=="Walk")),vect_stat[i]])
  dur[4,i] <- mean(database[which(database[,vect_stat[i]]!=0 & database[,c("Mode")]=="AV_partial"),vect_stat[i]])
  dur[5,i] <- mean(database[which(database[,vect_stat[i]]!=0 & database[,c("Mode")]=="AV_ideal"),vect_stat[i]])
  
  std[1,i] <- sd(database[which(database[,vect_stat[i]]!=0 & (database[,c("Mode")]=="Car_driver" | database[,c("Mode")]=="Car_pax")),vect_stat[i]])
  std[2,i] <- sd(database[which(database[,vect_stat[i]]!=0 & database[,c("Mode")]=="PT"),vect_stat[i]])
  std[3,i] <- sd(database[which(database[,vect_stat[i]]!=0 & (database[,c("Mode")]=="Bike" | database[,c("Mode")]=="Walk")),vect_stat[i]])
  std[4,i] <- sd(database[which(database[,vect_stat[i]]!=0 & database[,c("Mode")]=="AV_partial"),vect_stat[i]])
  std[5,i] <- sd(database[which(database[,vect_stat[i]]!=0 & database[,c("Mode")]=="AV_ideal"),vect_stat[i]])
  } 
sel
dur
std

#For on-board activities
sel = matrix(0, nrow = 5, ncol = 6)
dur = matrix(0, nrow = 5, ncol = 6)
std = matrix(0, nrow = 5, ncol = 6)
for (i in 1:6){
  sel[1,i] <- length(database[which(database[,vect_onb[i]]!=0 & (database[,c("Mode")]=="Car_driver" | database[,c("Mode")]=="Car_pax")),vect_onb[i]])/mode_users[1]
  sel[2,i] <- length(database[which(database[,vect_onb[i]]!=0 & database[,c("Mode")]=="PT"),vect_onb[i]])/mode_users[2]
  sel[3,i] <- length(database[which(database[,vect_onb[i]]!=0 & (database[,c("Mode")]=="Bike" | database[,c("Mode")]=="Walk")),vect_onb[i]])/mode_users[3]
  sel[4,i] <- length(database[which(database[,vect_onb[i]]!=0 & database[,c("Mode")]=="AV_partial"),vect_onb[i]])/mode_users[4]
  sel[5,i] <- length(database[which(database[,vect_onb[i]]!=0 & database[,c("Mode")]=="AV_ideal"),vect_onb[i]])/mode_users[5]
  
  dur[1,i] <- mean(database[which(database[,vect_onb[i]]!=0 & (database[,c("Mode")]=="Car_driver" | database[,c("Mode")]=="Car_pax")),vect_onb[i]])
  dur[2,i] <- mean(database[which(database[,vect_onb[i]]!=0 & database[,c("Mode")]=="PT"),vect_onb[i]])
  dur[3,i] <- mean(database[which(database[,vect_onb[i]]!=0 & (database[,c("Mode")]=="Bike" | database[,c("Mode")]=="Walk")),vect_onb[i]])
  dur[4,i] <- mean(database[which(database[,vect_onb[i]]!=0 & database[,c("Mode")]=="AV_partial"),vect_onb[i]])
  dur[5,i] <- mean(database[which(database[,vect_onb[i]]!=0 & database[,c("Mode")]=="AV_ideal"),vect_onb[i]])
  
  std[1,i] <- sd(database[which(database[,vect_onb[i]]!=0 & (database[,c("Mode")]=="Car_driver" | database[,c("Mode")]=="Car_pax")),vect_onb[i]])
  std[2,i] <- sd(database[which(database[,vect_onb[i]]!=0 & database[,c("Mode")]=="PT"),vect_onb[i]])
  std[3,i] <- sd(database[which(database[,vect_onb[i]]!=0 & (database[,c("Mode")]=="Bike" | database[,c("Mode")]=="Walk")),vect_onb[i]])
  std[4,i] <- sd(database[which(database[,vect_onb[i]]!=0 & database[,c("Mode")]=="AV_partial"),vect_onb[i]])
  std[5,i] <- sd(database[which(database[,vect_onb[i]]!=0 & database[,c("Mode")]=="AV_ideal"),vect_onb[i]])
  
} 
sel
dur
std
  
  
#DESCRIPTIVES: PEARSON AND SPEARMAN RANK CORRELATIONS BETWEEN STATIONARY AND ON-BOARD ACTIVITY CHANGES
dur_changes_stat = matrix(0, nrow = n, ncol = 6)
colnames(dur_changes_stat)<-paste(vect_stat_titles[1:6],"stationary")
dur_changes_onb = matrix(0, nrow = n, ncol = 6)
colnames(dur_changes_onb)<-paste(vect_onb_titles,"on board")
for (i in 1:6){
  dur_changes_stat[,i] <- database[(n+1):(2*n),vect_stat[i]]-database[1:n,vect_stat[i]]
  dur_changes_onb[,i] <- database[(n+1):(2*n),vect_onb[i]]-database[1:n,vect_onb[i]]
}

meth<-"pearson"
meth<-"spearman"

cor.mtest <- function(mat1,mat2,meth) {
  mat <- as.matrix(mat1,mat2)
  n <- ncol(mat1)
  p.mat<- matrix(NA, n, n)
  
  for (i in 1:n) {
    for (j in 1:n) {
      tmp <- cor.test(mat1[, i], mat2[, j],method=meth)
      p.mat[i, j] <- tmp$p.value
    }
  }
  colnames(p.mat) <- rownames(p.mat) <- colnames(mat)
  p.mat
}
# matrix of the p-value of the correlation
p.mat <- cor.mtest(dur_changes_onb,dur_changes_stat,meth)

pearson_cor_matrix<-cor(dur_changes_onb,dur_changes_stat,method=meth)
cor.test(dur_changes_onb[,1],dur_changes_stat[,1],method=meth)
corrplot(pearson_cor_matrix, tl.col="black", p.mat = p.mat, method="color",sig.level = 0.05,tl.srt=45, title="Pearson correlations",mar=c(0,0,2,2))
corrplot(pearson_cor_matrix, tl.col="black", p.mat = p.mat, method="color",sig.level = 0.05,tl.srt=45, title="Spearman correlations",mar=c(0,0,2,2))
