# -*- coding: utf-8 -*-
"""

MIT License, for detailes please read LICENSE.TXT

Copyright (c) 2022 Mahtab Sharifi

Created on Mon Mar 14 10:10:54 2022

"""
import sys
import os

sumo_path = 'J:\\sumo-win64\\sumo-1.11.0\\'

if 'SUMO_HOME' in os.environ:
     tools = os.path.join(os.environ['SUMO_HOME'], 'tools')
     sys.path.append(tools)
else:
    tools = os.path.join(sumo_path,'tools')
    sys.path.append(tools)
#     sys.exit("please declare environment variable 'SUMO_HOME'")

import sumolib

class SumoNetLib:

    net = None

    def __init__(self,sumo_net_file):
        self.net = sumolib.net.readNet(sumo_net_file)
    
    def getShortestRoute(self, orgn_edge_id, dest_edge_id, cost_limit = float('inf'), includeFrToCost=True):
        # https://sumo.dlr.de/daily/pydoc/sumolib.net.html
        # https://github.com/eclipse/sumo/blob/main/tests/tools/sumolib/getShortestRoute/runner.py
        
        t_net = self.net
        o_edge = t_net.getEdge(orgn_edge_id)
        d_edge = t_net.getEdge(dest_edge_id)
        route, cost = t_net.getShortestPath(o_edge, d_edge, maxCost=cost_limit, includeFromToCost=includeFrToCost)
        return route, round(cost, 3)
    
'''
https://sumo.dlr.de/daily/pydoc/sumolib.net.html
getShortestPath(self, fromEdge, toEdge, maxCost=inf, vClass=None, reversalPenalty=0, includeFromToCost=True, withInternal=False, ignoreDirection=False, fromPos=0, toPos=0)
    Finds the shortest path from fromEdge to toEdge respecting vClass, using Dijkstra's algorithm.
    It returns a pair of a tuple of edges and the cost. If no path is found the first element is None.
    The cost for the returned path is equal to the sum of all edge lengths in the path,
    including the internal connectors, if they are present in the network.
    The path itself does not include internal edges except for the case
    when the start or end edge are internal edges.
    The search may be limited using the given threshold.
'''

