# -*- coding: utf-8 -*-
"""
MIT License, for detailes please read LICENSE.TXT

Copyright (c) 2022 Mahtab Sharifi

Created on Tue Jul 19 15:21:46 2022

"""

import os, subprocess
from os import path as Path
import numpy as np
import pandas as pd


import General_Utils as gu


def getRunStr(pStr):
    ndx =  pStr.rfind('\\') + 1
    return pStr[ndx:]

def getCsvDf(pFilePath, sep=','):
    csv_df = pd.read_csv(pFilePath,sep=sep)
    csv_df = csv_df.convert_dtypes()
    return csv_df

def getOdFileName(pODTD):
    t_str = 'od_' + pODTD[0].replace('.','').replace(' ','_') + pODTD[2][0]
    return t_str
    
def getNetFullPath(pPrmsDict):
    t_path = Path.join(pPrmsDict['base_path'],pPrmsDict['net_path'])
    # t_path = pPrmsDict['base_path']
    return t_path

def getOutFolders(pPrmsDict):
    pBasePath, pSt, pEn = pPrmsDict['base_path'],pPrmsDict['run_start'],pPrmsDict['run_end']
    pPrefix = pPrmsDict['run_folder_prefix']
    t_out = []
    for i in range(pSt, pEn+1):
        t_dir = '{}{:0>3d}'.format(pPrefix,i)
        path = Path.join(pBasePath, t_dir)
        t_out.append(path)
    return t_out


def getMultiOD_FileNames(pPrmsDict, pTimeDistribution):
    t_path = Path.join(getNetFullPath(pPrmsDict), pPrmsDict['od_path'])
    t_multi_ods = []
    for t_tdod in pTimeDistribution:
        t_fname = Path.join(t_path, getOdFileName(t_tdod)+".txt")
        t_multi_ods.append(t_fname)
    return t_multi_ods


''' 
    ***************************************************************************
    
    Base Parameters
    
    ***************************************************************************
'''

import base_parameters 
prms_dict = base_parameters.prms_dict

prms_dict['od_path'] = 'od_files'
prms_dict['run_folder_prefix'] = 'sim_runs\\base_run\\run_'

time_distribution = base_parameters.time_distribution
        

''' 
    ***************************************************************************
    
    Main Part
    
    ***************************************************************************
'''

def get_route_cfg_str(pPrmsDict, pOutPath, pOD_Files, pWrite = False):
    route_cfg = [
    '<configuration>',
    '    <parameters>',
    '        <random value="True"/> ',
    '    </parameters>',
    '    <input>',
    '        <taz-files value="{}"/>'.format(Path.join(getNetFullPath(pPrmsDict), pPrmsDict['fn_sumo_grid'])), 
    '        <od-matrix-files value="{}"/>'.format(pOD_Files),
    '    </input>',
    '    <output>',
    '        <output-file value="{}"/>'.format(Path.join(pOutPath, 'rtm_batch.rou.xml')),
    '    </output>',
    '</configuration>',
            ]

    t_out = '\n'.join(route_cfg)
    if pWrite:
        gu.FileSave(Path.join(pOutPath,'rtm_batch_route.cfg'), t_out, wMode='w')
    return t_out


def creatRouteCfgFiles(pPrmsDict, pOutDirs, pTimeDistribution):
#    pBasePath = pPrmsDict['base_path']
    pOD_FileNames = getMultiOD_FileNames(pPrmsDict, pTimeDistribution)
    t_out = []
    od_files = ','.join(pOD_FileNames)
    for o_dir in pOutDirs:
        print('route cfg: {}'.format(getRunStr(o_dir)))
        t_rou = get_route_cfg_str(pPrmsDict, o_dir, od_files, pWrite = True)
        t_out.append(t_rou)
    return t_out


def creatRouteFilesMulti(pPrmsDict, pOutDirs):
    t_out = []
    my_env = os.environ.copy()
    t_cmd = Path.join(my_env['SUMO_HOME'],'bin', 'od2trips')
    for o_dir in pOutDirs:
        print('route: {}'.format(getRunStr(o_dir)))
        my_command = t_cmd + ' -c ' + '"' + Path.join(o_dir, 'rtm_batch_route.cfg') + '"'
        t_out.append(my_command)
        _ = subprocess.call(my_command)

    return t_out



# run whenever needed to create route files
t_out_dirs = getOutFolders(prms_dict)
t_multi_cfgs = creatRouteCfgFiles(prms_dict, t_out_dirs, time_distribution)
t_ruts = creatRouteFilesMulti(prms_dict, t_out_dirs)



