# -*- coding: utf-8 -*-
"""

MIT License, for detailes please read LICENSE.TXT

Copyright (c) 2022 Mahtab Sharifi

Created on Fri Jul 22 07:36:31 2022

"""
import os, subprocess
import General_Utils as gu


''' 
    ***************************************************************************
    
    init Part
    
    ***************************************************************************
'''

import base_parameters 
prms_dict = base_parameters.prms_dict

sim_scen = base_parameters.sim_scen


def getRunStr(pStr):
    ndx =  pStr.rfind('\\') + 1
    return pStr[ndx:]


def getScnFolders(pPrmsDict, pSim_Scn, pSimNdx):
    scn_path, run_path, rout_file, aggregate_path = pSim_Scn[pSimNdx]
    pBasePath, pSt, pEn = pPrmsDict['base_path'],pPrmsDict['run_start'],pPrmsDict['run_end']
    t_out = []
    for i in range(pSt, pEn+1):
        t_dir = '{}{:0>3d}'.format(run_path,i)
        path = os.path.join(pBasePath, scn_path, t_dir)
        t_out.append(path)
    return t_out


'''
    ***************************************************************************
    
    main Part
    
    ***************************************************************************
'''

def runSumoCmd(pPrmsDict, pSim_Scn, pSimNdx):
    scn_path, run_path, rout_file, aggregate_path = pSim_Scn[pSimNdx]
    t_run_dirs = getScnFolders(pPrmsDict, pSim_Scn, pSimNdx)
    
    t_out = []
    t_cmd = '%sumo_home%\\bin\\sumo'
    for o_dir in t_run_dirs:
        print('sumo cmd: {} \t {}'.format(getRunStr(o_dir), gu.getCurrentTime()))
        cd_cmd = 'cd /d ' + o_dir
        print(cd_cmd + ' & ' + t_cmd + ' -c rtm_batch.sumo.cfg')
        my_command = cd_cmd + ' & ' + t_cmd + ' -c rtm_batch.sumo.cfg'
        t_out.append(my_command)
        os.system('{}'.format(my_command))
    return t_out

'''
    ***************************************************************************
    
    Warning: Running each simulation will take around 30 minutes
             and there are 40 simulations so the total running 
             time of this code is about 20 hours
    
    ***************************************************************************
'''

if __name__ == '__main__':
    # this file is for fusion
    # pattern is: (parameters, scenario_list, scenario_ndx)
    
    # Simulate base case
    t_sums = runSumoCmd(prms_dict, sim_scen, 0)
    
    # Simulate algorith 1
    t_sums = runSumoCmd(prms_dict, sim_scen, 1)
    
    # Simulate algorith 2
    t_sums = runSumoCmd(prms_dict, sim_scen, 2)

    # Simulate algorith 2_without blocking
    t_sums = runSumoCmd(prms_dict, sim_scen, 3)