# -*- coding: utf-8 -*-
"""

MIT License, for detailes please read LICENSE.TXT

Copyright (c) 2022 Mahtab Sharifi

Created on Tue Jul 19 10:32:13 2022

"""

from os import path as Path
import numpy as np
import pandas as pd

import random
import General_Utils as gu


random.seed()
    
''' 
    ***************************************************************************
    
    Base Parameters
    
    ***************************************************************************
'''
prms_dict = {
        'base_path' : '..\\net_files\\',
        'net_path' : 'net_files',
        'od_path' : 'od_files',        

        'fn_taz_rank' : 'excel_taz_rank.txt',
        
        'count_cars' : 156000

        }


def getCsvDf(pFilePath, sep=','):
    csv_df = pd.read_csv(pFilePath,sep=sep)
    csv_df = csv_df.convert_dtypes()
    return csv_df

def getOdFileName(pODTD):
    t_str = 'od_' + pODTD[0].replace('.','').replace(' ','_') + pODTD[2][0]
    return t_str


def getNetFullPath(pPrmsDict):
    # t_path = Path.join(pPrmsDict['base_path'],pPrmsDict['net_path'])
    t_path = pPrmsDict['base_path']
    return t_path
    

def getTazRank(pPrmsDict):
    t_path = Path.join(getNetFullPath(pPrmsDict),pPrmsDict['fn_taz_rank'])
    tdf = getCsvDf(t_path, sep='\t')
    return tdf

'''
this is about o/d matrix creation

taz weighting
	use topsis to compose the parameters 
    we have somthing like test_list

distribute number of cars to the sink-tazs based on the topsis rank
    tsum = tdf['t_rank'].sum()
    tdf['cars'] = (pCars * tdf['t_rank'] / tsum ).round().astype(int)    

calculate complementary rank
    c_rank = getComplementary(t_rank_Series)

get the probability distribution cells based on c_rank
    we have a one dimentional list, tally (count) of the elements is base on c_rank
    getTazChanceCells(c_rank, sink_cars)

then for each sink TAZ
    we distribute the count of sink cars to the Taz_Chance_Cells (list) uniformly and find the sum for each TAZ
        scatterCars(destination, n_Cars, pTazChanceCells)
    

	for each source in sources
		eithor evenly distribute each sink to all other tazs
		or distribute based on the complementary tospsis rank (1- rank)

for afternoon traffic exchange the source and sink

'''

''' 
    ***************************************************************************
    
    Main Part
    
    ***************************************************************************
'''

# getExponent(0.000256,5)   returns 8 so 0.000256 * 100000000 is 25600 (has 5 digits)
def getExponent(pNum, precision = 2):
    limit = 10 ** precision
    cnt = 0
    tbuf = 0
    while tbuf < limit:
        cnt += 1
        tbuf = pNum * 10 ** cnt
    return cnt -1


def getComplementary(pSeries):
    t_min = pSeries.min()
    t_max = pSeries.max()
    t_base = t_max + t_min
    return t_base - pSeries

    
def getMultiplier(pSeries, precision=2):
    tsum = pSeries.sum()
    tbuf = pSeries / tsum
    tcnt = getExponent(tbuf.max(), precision)
    tmpl = 10 ** tcnt
    tout = (tbuf * tmpl + 0.5).astype(int)
    return tout

        
def getTazChanceCells(pSr1, pSr2, precision=2):
    out = []
    lsta = pSr1.to_list()
    lstb = getMultiplier(pSr2, precision)
    for i in range(len(lsta)):
        out.extend([lsta[i]] * lstb[i])
        
    return out 

def scatterCarsNp(pDest, pCars, pTazChanceCells):
    clst = [o for o in pTazChanceCells if o != pDest]
    cars = np.zeros(len(clst), dtype=int)
    t_len = len(clst) - 1
    for i in range(pCars):
        ndx = random.randint(0,t_len)
        cars[ndx] += 1
    cdf = pd.DataFrame({'orgn':clst, 'cars':cars})
    cdfsum = cdf.groupby(['orgn'], as_index=False).agg({'cars':'sum'})
    cdfsum['dest'] = pDest
    mask = cdfsum['cars'] == 0
    cdfsum.drop(cdfsum[mask].index, inplace=True)
    return cdfsum[['orgn', 'dest', 'cars']]



def getODmatrix(pDf, pCars, precision=2):
    tdf = pDf.copy()
    tsum = tdf['t_rank'].sum()
    tdf['cars'] = (pCars * tdf['t_rank'] / tsum ).round().astype(int)
#    clst = getTazChanceCells(tdf)
    buf = []
    tdf['c_rank'] = getComplementary(tdf['t_rank'])
    clst = getTazChanceCells(tdf['taz'], tdf['c_rank'], precision)
    for i in range(len(tdf)):
        dest = tdf['taz'].iloc[i]
        cars = tdf['cars'].iloc[i]
        buf.append(scatterCarsNp(dest, cars, clst))
    
    tout = pd.concat(buf)
    tout.reset_index(drop=True, inplace=True)

    return [tout, tdf]


def df2od(pODF, pT2T='7.00 8.00', pFactor=1.00, cbCopy = False):
    pFactor /= 1.00
    header = '$OR;D2\n* From-Time  To-Time\n{}\n* Factor\n{:0.2f}\n'.format(pT2T,pFactor)
    comment = '* created by pyhon on {}\n'.format(gu.getCurrentDateTime())
    tdf = pODF.copy()
    tdf['orgn'] = '\t' + tdf['orgn']
    out = header + comment + tdf.to_csv(sep='\t', header=False, index=False) # , quotechar='"')
    out = out.replace('"','')
    if cbCopy:
        gu.copy(out)
    return out

''' 
    ***************************************************************************
    
    distribution and od file creation part
    
    ***************************************************************************
'''
# duration, 100 * Percentile, type
time_distribution = [
    ['0.00 1.00', 0.3603604, 'random'],
    ['1.00 2.00', 0.1801802, 'random'],
    ['2.00 3.00', 0.1801802, 'random'],
    ['3.00 4.00', 0.5405405, 'random'],
    ['4.00 5.00', 1.0810811, 'random'],
    ['5.00 6.00', 1.4414414, 'random'],
    ['6.00 7.00', 2.7027027, 'weighted'],
    ['7.00 8.00', 5.2252252, 'weighted'],
    ['8.00 9.00', 7.7477477, 'weighted'],
    ['9.00 10.00', 5.5855856, 'random'],
    ['10.00 11.00', 4.3243243, 'random'],
    ['11.00 12.00', 3.6036036, 'random'],
    ['12.00 13.00', 3.963964, 'random'],
    ['13.00 14.00', 4.6846847, 'random'],
    ['14.00 15.00', 5.4054054, 'random'],
    ['15.00 16.00', 6.1261261, 'complimentary'],
    ['16.00 17.00', 9.9099099, 'complimentary'],
    ['17.00 18.00', 12.0720721, 'complimentary'],
    ['18.00 19.00', 8.2882883, 'complimentary'],
    ['19.00 20.00', 5.7657658, 'random'],
    ['20.00 21.00', 4.5045045, 'random'],
    ['21.00 22.00', 3.2432432, 'random'],
    ['22.00 23.00', 1.6216216, 'random'],
    ['23.00 23.59', 1.0810811, 'random'],
        ]


def creatOD_TimeDistribution(pPrmsDict, pTazRankDf, pTimeDistribution):

    t_path = Path.join(getNetFullPath(pPrmsDict), pPrmsDict['od_path'])
    od_precision = 2
    total_cars = 0
    t_multi_ods = []
    for t_tdod in pTimeDistribution:
        t_duration, t_percent, t_type = t_tdod
        n_cars = int(pPrmsDict['count_cars'] * t_percent / 100 + .05)
        print('file: {}   time: {}   {}   cars: {}'.format(getOdFileName(t_tdod), t_duration, t_type, n_cars))
        total_cars += n_cars
        t_tw = pTazRankDf.copy()
        if t_type == 'random' :
            t_tw.t_rank = 10.0
            t_od_matrix, _ = getODmatrix(t_tw, n_cars, precision=od_precision)
            
        elif t_type == 'weighted':
            t_od_matrix, _ = getODmatrix(t_tw, n_cars, precision=od_precision)
            
        elif t_type == 'complimentary':
            t_twc = getComplementary(t_tw['t_rank'])
            t_tw['t_rank'] = t_twc
            t_od_matrix, _ = getODmatrix(t_tw, n_cars, precision=od_precision)

        t_fname = Path.join(t_path, getOdFileName(t_tdod)+".txt")
        t_multi_ods.append(t_fname)
        t_od_str = df2od(t_od_matrix, pT2T = t_duration)
        gu.FileSave(t_fname, t_od_str, wMode = 'w')

    print('total cars: {}'.format(total_cars))
    return t_multi_ods


def getMultiOD_FileNames(pPrmsDict, pTimeDistribution):
    t_path = joinPath(getNetFullPath(pPrmsDict), pPrmsDict['od_path'])
    t_multi_ods = []
    for t_tdod in pTimeDistribution:
        t_fname = joinPath(t_path, getOdFileName(t_tdod)+".txt")
        t_multi_ods.append(t_fname)
    return t_multi_ods



# create route files multi O/D per hour
# run only once to create OD Matrix files 

t_taz_rank = getTazRank(prms_dict) 
t_multi_ods = creatOD_TimeDistribution(prms_dict, t_taz_rank, time_distribution)