# -*- coding: utf-8 -*-
"""
MIT License, for detailes please read LICENSE.TXT

Copyright (c) 2022 Mahtab Sharifi

Created on Tue Jul 19 14:39:48 2022

"""


import os, subprocess
import numpy as np
import pandas as pd

import General_Utils as gu


def getRunStr(pStr):
    ndx =  pStr.rfind('\\') + 1
    return pStr[ndx:]

def getCsvDf(pFilePath, sep=','):
    csv_df = pd.read_csv(pFilePath,sep=sep)
    csv_df = csv_df.convert_dtypes()
    return csv_df
    

''' 
    ***************************************************************************
    
    Main Part
    
    ***************************************************************************
'''


def getNetFullPath(pPrmsDict):
    t_path = os.path.join(pPrmsDict['base_path'],pPrmsDict['net_path'])
    return t_path

    
def getScnFolders(pPrmsDict, pSim_Scn, pSimNdx):
    scn_path, run_path, rout_file, aggregate_path = pSim_Scn[pSimNdx]
    pBasePath, pSt, pEn = pPrmsDict['base_path'],pPrmsDict['run_start'],pPrmsDict['run_end']
#    pPrefix = pPrmsDict['model_folder_prefix']
    t_out = []
    for i in range(pSt, pEn+1):
        t_dir = '{}{:0>3d}'.format(run_path,i)
        path = os.path.join(pBasePath, scn_path, t_dir)
        t_out.append(path)
    return t_out


def make_get_ScnFolders(pPrmsDict, pSim_Scn, pSimNdx, verbose=False):
    scn_path, run_path, rout_file, aggregate_path = pSim_Scn[pSimNdx]
    t_out = getScnFolders(pPrmsDict, pSim_Scn, pSimNdx)
    for i, t_path in enumerate(t_out):
        if os.path.exists(t_path) and os.path.isdir(t_path):
            continue
        os.makedirs(t_path,exist_ok=False)
        if verbose:
            print('Directory created: {}'.format(getRunStr(t_path)))
    return t_out


def make_get_ResultFolders(pPrmsDict, pSim_Scn, verbose=False):
    t_out = []
    t_base_path = pPrmsDict['base_path']
    for ndx, t_scen in enumerate(pSim_Scn):
        scn_path, run_path, rout_file, result_path = t_scen
        t_path = os.path.join(t_base_path, scn_path, result_path)
        if os.path.exists(t_path) and os.path.isdir(t_path):
            continue
        os.makedirs(t_path,exist_ok=False)
        t_out.append(t_path)
        if verbose:
            print('Directory created: {}'.format(getRunStr(t_path)))
    return t_out


def get_cfg_str(pPrmsDict, pOutPath, pRouFname, pWrite = False):
    pBasePath, pTimeSt, pTimeEn = pPrmsDict['base_path'],pPrmsDict['start_time'],pPrmsDict['end_time']
    pBaseSub = pPrmsDict['net_path']
    
    base_cfg = [
    '<configuration>',
    '    <parameters>',
    '        <ignore-junction-blocker value="90"/>',
    '        <ignore-route-errors value="True"/> ',
    '        <time-to-teleport value="300"/> ',
    '        <time-to-teleport.disconnected value="30"/> ',
    '        <eager-insert value="True"/> ',
    '        <lanechange.overtake-right value="True"/>',
    '        <device.rerouting.with-taz value="False"/>',
#    '        <aggregate-warnings value="0"/>',
    '        <no-warnings value="True"/>',     
    '    </parameters>',
    '    <input>',
    '        <net-file value="{}"/>'.format(os.path.join(pBasePath, pBaseSub,'rtm_netconvert.net.xml')),
    '        <route-files value="{}"/>'.format(os.path.join(pOutPath, pRouFname)),
    '        <additional-files value="{}"/>'.format(os.path.join(pOutPath, 'rtm_batch_emm.def.xml')),
#    '        <route-files value="{}"/>'.format('rtm_batch.rou.xml'),
#    '        <additional-files value="{}"/>'.format('emm_batch.def.xml'),
    '    </input>',
    '    <time>',
    '        <begin value="{}"/>'.format(pTimeSt),
    '        <end value="{}"/>'.format(pTimeEn),
    '    </time>',
    '    <output>',
    '        <tripinfo-output value="{}"/>'.format(os.path.join(pOutPath, 'o_rtm.trip_output.xml')),
    '        <summary-output value="{}"/>'.format(os.path.join(pOutPath, 'o_rtm.smry_output.xml')),
    '    <statistic-output value="{}"/>'.format(os.path.join(pOutPath, 'o_rtm.stat_output.xml')),
    '    </output>',
    '</configuration>',
            ]
    t_out = '\n'.join(base_cfg)
    if pWrite:
        gu.FileSave(os.path.join(pOutPath,'rtm_batch.sumo.cfg'), t_out, wMode='w')
    return t_out


def creatCfgFiles(pPrmsDict, pSim_Scn, pSimNdx):
    scn_path, run_path, rout_file, aggregate_path = pSim_Scn[pSimNdx]
    t_run_dirs = getScnFolders(pPrmsDict, pSim_Scn, pSimNdx)
    t_out = []
    for o_dir in t_run_dirs:
        print('cfg: {}'.format(getRunStr(o_dir)))
        t_cfg = get_cfg_str(pPrmsDict, o_dir, rout_file, pWrite = True)
        t_out.append(t_cfg)
    return t_out


def get_emm_str(pOutPath, pWrite = False):
    base_emm = [
    '<?xml version="1.0" encoding="UTF-8"?>',
    '<additional>',
    '   <edgeData id="my_detector"  type="emissions" file="{}" excludeEmpty="false"/>'.format(os.path.join(pOutPath, 'o_emissions.xml')),
    '   <edgeData id="my_detector"  file="{}" excludeEmpty="false"/>'.format(os.path.join(pOutPath, 'o_edgedump.xml')),
    '</additional>',
            ]
    t_out = '\n'.join(base_emm)
    if pWrite:
        gu.FileSave(os.path.join(pOutPath,'rtm_batch_emm.def.xml'), t_out, wMode='w')
    return t_out


def creatEmmFiles(pPrmsDict, pSim_Scn, pSimNdx):
    scn_path, run_path, rout_file, aggregate_path = pSim_Scn[pSimNdx]
    t_run_dirs = getScnFolders(pPrmsDict, pSim_Scn, pSimNdx)
    t_out = []
    for o_dir in t_run_dirs:
        print('emission: {}'.format(getRunStr(o_dir)))
        t_emm = get_emm_str(o_dir, pWrite = True)
        t_out.append(t_emm)
    return t_out


''' 
    ***************************************************************************
    
    Base Parameters
    
    ***************************************************************************
'''

import base_parameters 
prms_dict = base_parameters.prms_dict


#       [ scn_path , run_path     , rout_file              , aggregate_path   ],
sim_scen = base_parameters.sim_scen


'''
    ***************************************************************************
    
    run Part
    Remove the commented lines to create folders and configure file for all simulation runs
    
    ***************************************************************************
'''

#step 1: create directories
# for scn_ndx in range(len(sim_scen)):
    # t_out_dirs = make_get_ScnFolders(prms_dict, sim_scen, scn_ndx, verbose=1)
    
#setp2: create Results directories
# t_results_dirs = make_get_ResultFolders(prms_dict, sim_scen, verbose=1)

#setp3: create sumo.cfg files
# for scn_ndx in range(len(sim_scen)):
    # t_cfgs = creatCfgFiles(prms_dict, sim_scen, scn_ndx)
    
#setp4: create emm.xml files
# for scn_ndx in range(len(sim_scen)):
    # t_emms = creatEmmFiles(prms_dict, sim_scen, scn_ndx)



