# -*- coding: utf-8 -*-
"""
MIT License, for detailes please read LICENSE.TXT

Copyright (c) 2022 Mahtab Sharifi

Created on Tue Jul 19 15:26:02 2022

"""


''' 
    ***************************************************************************
    
    Base Parameters
    
    ***************************************************************************
'''
prms_dict = {
        # this path needs to be absolute, SUMO does not support reletive paths 
        'base_path' : 'G:\\TU Delft\\Master Thesis\\To_Upload\\',

        'net_path' : 'net_files',
        'net_file' : 'rtm_netconvert.net.xml',
        'edg_ids_file' : 'rtm_edg_ids.txt',
        'edg_len_file' : 'rtm_edg_len.txt',
        'taz_int_id' : 'rtm_taz_int_id.txt',

        'e2e_path' : 'e2e_files',
        'e2e_file_prefix' : 'e2e_',
        'e2e_file_suffix' : '.hex',
        
        'start_time' : '0:00:00',
        'end_time' : '23:59:00',

        'run_start' : 1,
        'run_end' : 10,
        
        'fn_edges' : 'rtm_netconvert.plain.edg.xml',
        'fn_nodes' : 'rtm_netconvert.plain.nod.xml',
        'fn_py_grid' : 'taz_gd_py.xml',
        'fn_sumo_grid' : 'taz_gd_sumo.xml',
        
        
        'count_cars' : 156000

        }


sim_scen =[
        ['sim_runs\\base_run', 'run_'       , 'rtm_batch.rou.xml'    , 'results'       ], 
        ['sim_runs\\scn_alg1', 'alg1_run_'  , 'rtm_alg1.rou.xml'     , 'alg1_results'  ],
        ['sim_runs\\scn_alg2', 'alg2_run_'  , 'rtm_alg2.rou.xml'     , 'alg2_results'  ],
        ['sim_runs\\scn_nstp2', 'nstp_run_'  , 'rtm_nstp.rou.xml'     , 'nstp_results'],
        ]


time_distribution = [
    ['0.00 1.00', 0.3603604, 'random'],
    ['1.00 2.00', 0.1801802, 'random'],
    ['2.00 3.00', 0.1801802, 'random'],
    ['3.00 4.00', 0.5405405, 'random'],
    ['4.00 5.00', 1.0810811, 'random'],
    ['5.00 6.00', 1.4414414, 'random'],
    ['6.00 7.00', 2.7027027, 'weighted'],
    ['7.00 8.00', 5.2252252, 'weighted'],
    ['8.00 9.00', 7.7477477, 'weighted'],
    ['9.00 10.00', 5.5855856, 'random'],
    ['10.00 11.00', 4.3243243, 'random'],
    ['11.00 12.00', 3.6036036, 'random'],
    ['12.00 13.00', 3.963964, 'random'],
    ['13.00 14.00', 4.6846847, 'random'],
    ['14.00 15.00', 5.4054054, 'random'],
    ['15.00 16.00', 6.1261261, 'complimentary'],
    ['16.00 17.00', 9.9099099, 'complimentary'],
    ['17.00 18.00', 12.0720721, 'complimentary'],
    ['18.00 19.00', 8.2882883, 'complimentary'],
    ['19.00 20.00', 5.7657658, 'random'],
    ['20.00 21.00', 4.5045045, 'random'],
    ['21.00 22.00', 3.2432432, 'random'],
    ['22.00 23.00', 1.6216216, 'random'],
    ['23.00 23.59', 1.0810811, 'random'],
        ]