"""
MIT License, for detailes please read LICENSE.TXT

Copyright (c) 2022 Mahtab Sharifi

Created on Mon Dec  2 14:13:54 2019

"""

import os

from requests import get as urlbyteget
from time import sleep

import random

from datetime import datetime

import numpy as np
import pandas as pd

from fastnumbers import fast_float
from fastnumbers import fast_int

import win32clipboard


def copy(text):
    try:
        win32clipboard.OpenClipboard()
        win32clipboard.EmptyClipboard()
        win32clipboard.SetClipboardText(text, win32clipboard.CF_UNICODETEXT)
        win32clipboard.CloseClipboard()
    except Exception as e:
        print(str(e))
        win32clipboard.CloseClipboard()


def paste():
    win32clipboard.OpenClipboard()
    data = win32clipboard.GetClipboardData(win32clipboard.CF_UNICODETEXT)
    win32clipboard.CloseClipboard()
    return data

def nppaste(pType = int, sep = '\r\n'):
    td = paste()
    tnp = npStr2Arr(td)
    return tnp

def npStr2Arr(pStr, pType = int, sep = '\r\n'):
    tnp = np.fromstring(pStr, dtype=pType, sep=sep)
    return tnp

def excelread(pHeader = None, sep = '\t'):
    data=pd.read_clipboard(header=pHeader, sep = sep) #.values
    print("Read Clipboard form Excel.")
    return data

def  excelwrite(data):
    # copy to clipboard 
    df = pd.DataFrame(data)
    df.to_clipboard(excel = True) 
    print("Copied to Clipboard for Excel.")

def FileSave(filename,content, wMode = 'a'):
    with open(filename, wMode, encoding="utf-8") as myfile:
        myfile.write(content)

def readFile2Str(pFileName):
    with open(pFileName,'r',encoding='utf8') as f:
        text = f.read()
    return text

def removeDblSpaces(string):
    while '  ' in string:
        string = string.replace('  ', ' ')
    return string

def list2txt(pList):
    ts = str(pList)
    ts = ts.replace('], ', '\n')
    ts = ts.replace(']', '')
    ts = ts.replace('[', '')
    ts = ts.replace(', ', ',')
    ts = ts.replace(',', '\t')
    ts = ts.replace('\'', '')
    return ts

def listDiff(pListA, pListB):
    la = compareList(pListA, pListB, pMode=1)
    lb = compareList(pListB, pListA)
    return [lb, la]

def compareList(pLstA, pLstB, pMode=1): # 1 is difference, 2 is intersection, 3 is union
    if pMode == 1:
        return list(set(pLstA).difference(set(pLstB)))
    elif pMode == 2:
        return list(set(pLstA).intersection(set(pLstB)))
    elif pMode == 3:
        return list(set(pLstA).union(set(pLstB)))
    else:
        print('valid pModes are: 1: difference, 2: intersection, 3: union')

def delete_file(pFileName):
    if os.path.exists(pFileName) and os.path.isfile(pFileName):
        os.remove(pFileName)

'''
def getCurrentJdate(sep = '-', pTime = False):
    time = datetime.now()
    ISO_8601_DateTime = time.isoformat()
    ISO_8601_time = ISO_8601_DateTime[:10]
    j_date = jalali.Gregorian(ISO_8601_time).persian_string()
    if sep != '-':
        j_date = j_date.replace('-', sep)
    if pTime:
        j_date += ' ' + ISO_8601_DateTime[11:19].replace(':','.')
    return j_date
'''

def getCurrentEdate(sep = '-'):
    time = datetime.now()
    ISO_8601_dt = time.isoformat()[:19]
    if sep != '-':
        ISO_8601_dt = ISO_8601_dt.replace('-', sep)
    return ISO_8601_dt

def getCurrentTime(sep = ':'):
    time = datetime.now()
    ISO_8601_DateTime = time.isoformat()
    iso_time = ISO_8601_DateTime[11:19]
    if sep != ':':
        iso_time = iso_time.replace(':', sep)
    return iso_time

def getCurrentDateTime(sep = ':'):
    time = datetime.now()
    ISO_8601_DateTime = time.isoformat()
    if sep != ':':
        ISO_8601_DateTime = ISO_8601_DateTime.replace(':', sep)
    return ISO_8601_DateTime[:19]

def getSingleReturn(pStr, cbCopy = False):
    out = pStr.replace('\n\n','\n')
    if cbCopy: copy(out)
    return out

def minutes2hours(pMinutes):
    hours, minutes = divmod(pMinutes, 60)
    return '{0:}:{1:02}'.format(int(hours), int(minutes))

''' 
    ***************************************************************************
    
    web part
    
    ***************************************************************************
'''

def rndSleep(pWait = 2.2, pVariance = 0.55):
    if pVariance > 0:
        tsleep = round(random.uniform(pWait, pWait+pVariance), 2)
    else:
        tsleep = pWait
    sleep(tsleep)

def msgSleep(pMsg, pWait = 2.2, pVariance = 0.55):
    if pVariance > 0:
        tsleep = round(random.uniform(pWait, pWait+pVariance), 2)
    else:
        tsleep = pWait
    print('{} {}'.format(pMsg, tsleep))
    sleep(tsleep)

def getDownloadContent(pUrl, pWait = 2.2, pVariance = 0.55):
    msgSleep(pUrl, pWait, pVariance)
    tresponse = urlbyteget(pUrl, allow_redirects=True, timeout=30) # , verify=False)
    tcontent = tresponse.content
    return tcontent

def getWebNum(pStr):
    
    
    tstr = pStr.replace(',','')
    tstr = ' '.join(tstr.split())
    tlist = tstr.split()
    if len(tlist) == 0: return 0
    tint = fast_int(tlist[0])
    tflt = fast_float(tlist[0])
    co = 1
    if len(tlist) > 1:
        if tlist[1] == 'M': co = 1e6
        elif tlist[1] == 'B': co = 1e9
        elif tlist[1] == '%'  and len(tlist) == 2: co= 1e-2
        
    if isinstance(tflt, str):
        tout = tflt
    else:
        if tint == tflt: tout = tint * co
        else: tout = tflt * co
    return tout

ColorCycle = ['#1f77b4',
             '#ff7f0e',
             '#2ca02c',
             '#d62728',
             '#9467bd',
             '#8c564b',
             '#e377c2',
             '#7f7f7f',
             '#bcbd22',
             '#17becf']

def getColorCycle(pNdx):
    return ColorCycle[pNdx % len(ColorCycle)]

def getColorCycleList(pCount, pStart=0):
    t_len = len(ColorCycle)
    pStart = pStart % t_len
    t_list = ColorCycle * (int(pCount / t_len) + 2)
    return t_list[pStart : pStart + pCount]

''' 
    ***************************************************************************
    
    read write Part
    
    ***************************************************************************
'''

def read_DF_csv(pFullPathFn, pHeader = None):
    tdf = pd.read_csv(pFullPathFn, sep='\t', header=pHeader).convert_dtypes()
    print(tdf.dtypes)
    return tdf

def write_DF_csv(pFullPathFn, pDf, pHeader = None):
    pDf.to_csv(pFullPathFn, sep = '\t', index=False, header = pHeader)
