# Dataset for *A Review on Shape Optimization of Hulls and Airfoils Leveraging Computational Fluid Dynamics Data-Driven Surrogate Models*

## Description

This spreadsheet contains a structured compilation of academic works in the field of shape optimization using surrogate models trained on CFD data. It is designed to support literature analysis, classification, and synthesis within this research area.

### Contents

- **File:** `Review.xlsx`  
- **Structure:**  
  The spreadsheet includes structured metadata on each reviewed paper, categorized by:
  - Optimization Objective(s)
  - Parametrization method
  - Type of Surrogate Model
  - Simulation approach (CFD, RANS, etc.)
  - Dimensionality
  - Geometrical context (hull or airfoil)
  - Notes on physical plausibility, validation, and generalization

## Usage

This dataset is intended for:
- Researchers performing systematic reviews or meta-analyses in surrogate-based shape optimization.
- Practitioners seeking comparative insights across various methods and approaches.
- Educators and students exploring trends in CFD-informed surrogate modelling and optimization.

## License

This dataset is shared under the **Creative Commons Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)** license.  
You are free to share and adapt the material, provided appropriate credit is given, and the usage is non-commercial.

## Citation

If you use this dataset, please cite the associated review paper:

> Walker, J. M., Coraddu, A., and Oneto, L. *A review on shape optimization of hulls and airfoils leveraging Computational Fluid Dynamics Data-Driven Surrogate models*, Ocean Engineering, Volume 312, Part 3, 2024, 119263, https://doi.org/10.1016/j.oceaneng.2024.119263.

For convience, please find the bibtex below:

@article{walker2025review,
  title = {A review on shape optimization of hulls and airfoils leveraging Computational Fluid Dynamics Data-Driven Surrogate models},
  journal = {Ocean Engineering},
  volume = {312},
  pages = {119263},
  year = {2024},
  issn = {0029-8018},
  author = {Walker, J.M. and Coraddu, A. and Oneto, L.},
}
